/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.service.AnalyticDistributionLineService;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderLineServiceImpl;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderLineServiceSupplychainImpl
extends PurchaseOrderLineServiceImpl {
    @Inject
    protected AnalyticDistributionLineService analyticDistributionLineService;
    @Inject
    protected UnitConversionService unitConversionService;
    private static final Logger LOG = LoggerFactory.getLogger(PurchaseOrderLineServiceSupplychainImpl.class);

    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder purchaseOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une ligne de commande fournisseur pour le produit : {}", new Object[]{saleOrderLine.getProductName()});
        Unit unit = null;
        BigDecimal qty = BigDecimal.ZERO;
        if (!saleOrderLine.getIsTitleLine().booleanValue()) {
            unit = saleOrderLine.getProduct().getPurchasesUnit();
            qty = saleOrderLine.getQty();
            if (unit == null) {
                unit = saleOrderLine.getUnit();
            } else {
                qty = this.unitConversionService.convertWithProduct(saleOrderLine.getUnit(), unit, qty, saleOrderLine.getProduct());
            }
        }
        PurchaseOrderLine purchaseOrderLine = super.createPurchaseOrderLine(purchaseOrder, saleOrderLine.getProduct(), saleOrderLine.getProductName(), saleOrderLine.getDescription(), qty, unit);
        purchaseOrderLine.setIsTitleLine(saleOrderLine.getIsTitleLine());
        this.computeAnalyticDistribution(purchaseOrderLine);
        return purchaseOrderLine;
    }

    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder purchaseOrder, Product product, String productName, String description, BigDecimal qty, Unit unit) throws AxelorException {
        PurchaseOrderLine purchaseOrderLine = super.createPurchaseOrderLine(purchaseOrder, product, productName, description, qty, unit);
        return purchaseOrderLine;
    }

    public PurchaseOrderLine computeAnalyticDistribution(PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        List analyticDistributionLineList = purchaseOrderLine.getAnalyticDistributionLineList();
        if ((analyticDistributionLineList == null || analyticDistributionLineList.isEmpty()) && this.generalService.getGeneral().getAnalyticDistributionTypeSelect() != 1) {
            analyticDistributionLineList = this.analyticDistributionLineService.generateLines(purchaseOrderLine.getPurchaseOrder().getSupplierPartner(), purchaseOrderLine.getProduct(), purchaseOrderLine.getPurchaseOrder().getCompany(), purchaseOrderLine.getExTaxTotal());
            if (analyticDistributionLineList != null) {
                for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                    analyticDistributionLine.setPurchaseOrderLine(purchaseOrderLine);
                    analyticDistributionLine.setAmount(this.analyticDistributionLineService.computeAmount(analyticDistributionLine));
                    analyticDistributionLine.setDate(this.generalService.getTodayDate());
                }
                purchaseOrderLine.setAnalyticDistributionLineList(analyticDistributionLineList);
            }
        } else if (analyticDistributionLineList != null && this.generalService.getGeneral().getAnalyticDistributionTypeSelect() != 1) {
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                analyticDistributionLine.setPurchaseOrderLine(purchaseOrderLine);
                analyticDistributionLine.setAmount(this.analyticDistributionLineService.computeAmount(analyticDistributionLine));
                analyticDistributionLine.setDate(this.generalService.getTodayDate());
            }
        }
        return purchaseOrderLine;
    }

    public PurchaseOrderLine createAnalyticDistributionWithTemplate(PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        List analyticDistributionLineList = null;
        analyticDistributionLineList = this.analyticDistributionLineService.generateLinesWithTemplate(purchaseOrderLine.getAnalyticDistributionTemplate(), purchaseOrderLine.getExTaxTotal());
        if (analyticDistributionLineList != null) {
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                analyticDistributionLine.setPurchaseOrderLine(purchaseOrderLine);
            }
        }
        purchaseOrderLine.setAnalyticDistributionLineList(analyticDistributionLineList);
        return purchaseOrderLine;
    }
}

