/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderServiceImpl;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.LocationRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderServiceSupplychainImpl
extends PurchaseOrderServiceImpl {
    @Inject
    protected UnitConversionService unitConversionService;
    @Inject
    protected StockMoveRepository stockMoveRepo;
    private static final Logger LOG = LoggerFactory.getLogger(PurchaseOrderServiceSupplychainImpl.class);

    public PurchaseOrder createPurchaseOrder(User buyerUser, Company company, Partner contactPartner, Currency currency, LocalDate deliveryDate, String internalReference, String externalReference, Location location, LocalDate orderDate, PriceList priceList, Partner supplierPartner) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une commande fournisseur : Soci\u00e9t\u00e9 = {},  Reference externe = {}, Fournisseur = {}", new Object[]{company.getName(), externalReference, supplierPartner.getFullName()});
        PurchaseOrder purchaseOrder = super.createPurchaseOrder(buyerUser, company, contactPartner, currency, deliveryDate, internalReference, externalReference, orderDate, priceList, supplierPartner);
        purchaseOrder.setLocation(location);
        return purchaseOrder;
    }

    public Long createStocksMove(PurchaseOrder purchaseOrder) throws AxelorException {
        Long stockMoveId = null;
        if (purchaseOrder.getPurchaseOrderLineList() != null && purchaseOrder.getCompany() != null) {
            StockConfigService stockConfigService = (StockConfigService)Beans.get(StockConfigService.class);
            Company company = purchaseOrder.getCompany();
            StockConfig stockConfig = stockConfigService.getStockConfig(company);
            Location startLocation = ((LocationRepository)Beans.get(LocationRepository.class)).findByPartner(purchaseOrder.getSupplierPartner());
            if (startLocation == null) {
                startLocation = stockConfigService.getSupplierVirtualLocation(stockConfig);
            }
            if (startLocation == null) {
                throw new AxelorException(String.format(I18n.get((String)"%s please configure a virtual supplier stock location for the company %s"), company.getName()), 4, new Object[0]);
            }
            Partner supplierPartner = purchaseOrder.getSupplierPartner();
            Address address = ((PartnerService)Beans.get(PartnerService.class)).getDeliveryAddress(supplierPartner);
            StockMove stockMove = ((StockMoveService)Beans.get(StockMoveService.class)).createStockMove(address, null, company, supplierPartner, startLocation, purchaseOrder.getLocation(), purchaseOrder.getDeliveryDate(), purchaseOrder.getNotes());
            stockMove.setPurchaseOrder(purchaseOrder);
            stockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
            stockMove.setEstimatedDate(purchaseOrder.getDeliveryDate());
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                StockMoveLine stockMoveLine;
                Product product = purchaseOrderLine.getProduct();
                if (product != null && (stockConfig.getHasInSmForStorableProduct().booleanValue() && "storable".equals(product.getProductTypeSelect()) || stockConfig.getHasInSmForNonStorableProduct().booleanValue() && !"storable".equals(product.getProductTypeSelect())) && !"subscriptable".equals(product.getProductTypeSelect())) {
                    StockMoveLine stockMoveLine2;
                    Unit unit = purchaseOrderLine.getProduct().getUnit();
                    BigDecimal qty = purchaseOrderLine.getQty();
                    BigDecimal priceDiscounted = purchaseOrderLine.getPriceDiscounted();
                    if (!unit.equals((Object)purchaseOrderLine.getUnit())) {
                        qty = this.unitConversionService.convertWithProduct(purchaseOrderLine.getUnit(), unit, qty, purchaseOrderLine.getProduct());
                        priceDiscounted = this.unitConversionService.convertWithProduct(purchaseOrderLine.getUnit(), unit, priceDiscounted, purchaseOrderLine.getProduct());
                    }
                    if ((stockMoveLine2 = ((StockMoveLineService)Beans.get(StockMoveLineService.class)).createStockMoveLine(product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), qty, priceDiscounted, unit, stockMove, 2, purchaseOrder.getInAti().booleanValue(), purchaseOrderLine.getTaxLine().getValue())) == null) continue;
                    stockMoveLine2.setPurchaseOrderLine(purchaseOrderLine);
                    stockMove.getStockMoveLineList().add(stockMoveLine2);
                    continue;
                }
                if (!purchaseOrderLine.getIsTitleLine().booleanValue() || (stockMoveLine = ((StockMoveLineService)Beans.get(StockMoveLineService.class)).createStockMoveLine(product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), BigDecimal.ZERO, BigDecimal.ZERO, null, stockMove, 2, purchaseOrder.getInAti().booleanValue(), null)) == null) continue;
                stockMoveLine.setPurchaseOrderLine(purchaseOrderLine);
                stockMove.getStockMoveLineList().add(stockMoveLine);
            }
            if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
                stockMove.setExTaxTotal(((StockMoveService)Beans.get(StockMoveService.class)).compute(stockMove));
                ((StockMoveService)Beans.get(StockMoveService.class)).plan(stockMove);
            }
            stockMoveId = stockMove.getId();
        }
        return stockMoveId;
    }

    public Location getLocation(Company company) {
        return (Location)((LocationRepository)Beans.get(LocationRepository.class)).all().filter("self.company = ?1 and self.isDefaultLocation = ?2 and self.typeSelect = ?3", new Object[]{company, true, 1}).fetchOne();
    }

    public void clearPurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        List stockMoveList = ((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.purchaseOrder = ?1 AND self.statusSelect = 2", new Object[]{purchaseOrder}).fetch();
        for (StockMove stockMove : stockMoveList) {
            ((StockMoveService)Beans.get(StockMoveService.class)).cancel(stockMove);
        }
    }

    public boolean existActiveStockMoveForPurchaseOrder(Long purchaseOrderId) {
        long nbStockMove = ((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.purchaseOrder.id = ? AND self.statusSelect <> ?", new Object[]{purchaseOrderId, 4}).count();
        return nbStockMove > 0L;
    }

    @Transactional
    public void generateBudgetDistribution(PurchaseOrder purchaseOrder) {
        if (purchaseOrder.getPurchaseOrderLineList() != null) {
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                if (purchaseOrderLine.getBudget() == null || !purchaseOrderLine.getBudgetDistributionList().isEmpty()) continue;
                BudgetDistribution budgetDistribution = new BudgetDistribution();
                budgetDistribution.setBudget(purchaseOrderLine.getBudget());
                budgetDistribution.setAmount(purchaseOrderLine.getExTaxTotal());
                purchaseOrderLine.addBudgetDistributionListItem(budgetDistribution);
            }
        }
    }

    @Transactional
    public PurchaseOrder mergePurchaseOrders(List<PurchaseOrder> purchaseOrderList, Currency currency, Partner supplierPartner, Company company, Location location, Partner contactPartner, PriceList priceList) throws AxelorException {
        String numSeq = "";
        String externalRef = "";
        for (PurchaseOrder purchaseOrderLocal : purchaseOrderList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + purchaseOrderLocal.getPurchaseOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (purchaseOrderLocal.getExternalReference() == null) continue;
            externalRef = externalRef + purchaseOrderLocal.getExternalReference();
        }
        PurchaseOrder purchaseOrderMerged = this.createPurchaseOrder(AuthUtils.getUser(), company, contactPartner, currency, null, numSeq, externalRef, location, LocalDate.now(), priceList, supplierPartner);
        super.attachToNewPurchaseOrder(purchaseOrderList, purchaseOrderMerged);
        this.computePurchaseOrder(purchaseOrderMerged);
        this.purchaseOrderRepo.save((Model)purchaseOrderMerged);
        super.removeOldPurchaseOrders(purchaseOrderList);
        return purchaseOrderMerged;
    }

    @Transactional
    public void updatePurchaseOrderOnCancel(StockMove stockMove, PurchaseOrder purchaseOrder) {
        List stockMoveList = Lists.newArrayList();
        stockMoveList = this.stockMoveRepo.all().filter("self.purchaseOrder = ?1", new Object[]{purchaseOrder}).fetch();
        purchaseOrder.setReceiptState(1);
        for (StockMove stock : stockMoveList) {
            if (stock.getStatusSelect() == 4 || stock.getId().equals(stockMove.getId())) continue;
            purchaseOrder.setReceiptState(2);
            break;
        }
        if (purchaseOrder.getStatusSelect() == 4 && this.generalService.getGeneral().getTerminatePurchaseOrderOnReceipt().booleanValue()) {
            purchaseOrder.setStatusSelect(3);
        }
        this.purchaseOrderRepo.save((Model)purchaseOrder);
    }
}

