/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;

public interface SaleOrderInvoiceService {
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateInvoice(SaleOrder var1) throws AxelorException;

    public SaleOrder fillSaleOrder(SaleOrder var1, Invoice var2);

    public Invoice createInvoice(SaleOrder var1) throws AxelorException;

    public Invoice createInvoice(SaleOrder var1, List<SaleOrderLine> var2) throws AxelorException;

    public InvoiceGenerator createInvoiceGenerator(SaleOrder var1) throws AxelorException;

    public List<InvoiceLine> createInvoiceLines(Invoice var1, List<SaleOrderLine> var2) throws AxelorException;

    public List<InvoiceLine> createInvoiceLine(Invoice var1, SaleOrderLine var2) throws AxelorException;

    public BigDecimal getInvoicedAmount(SaleOrder var1);

    public BigDecimal getInvoicedAmount(SaleOrder var1, Long var2, boolean var3);

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateSubscriptionInvoice(List<Subscription> var1, SaleOrder var2) throws AxelorException;

    public void fillInLines(Invoice var1);

    @Transactional
    public Invoice generateSubcriptionInvoiceForSaleOrderLine(SaleOrderLine var1) throws AxelorException;

    @Transactional
    public Invoice generateSubcriptionInvoiceForSaleOrder(SaleOrder var1) throws AxelorException;

    @Transactional
    public Invoice generateSubcriptionInvoiceForSaleOrderAndListSubscrip(Long var1, List<Long> var2) throws AxelorException;

    @Transactional
    public Invoice mergeInvoice(List<Invoice> var1, Company var2, Currency var3, Partner var4, Partner var5, PriceList var6, PaymentMode var7, PaymentCondition var8, SaleOrder var9) throws AxelorException;
}

