/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.apps.supplychain.db.repo.SubscriptionRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderInvoiceServiceImpl
implements SaleOrderInvoiceService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private LocalDate today;
    protected GeneralService generalService;
    @Inject
    private SaleOrderRepository saleOrderRepo;
    @Inject
    private InvoiceService invoiceService;

    @Inject
    public SaleOrderInvoiceServiceImpl(GeneralService generalService) {
        this.generalService = generalService;
        this.today = this.generalService.getTodayDate();
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateInvoice(SaleOrder saleOrder) throws AxelorException {
        Invoice invoice = this.createInvoice(saleOrder);
        ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)invoice);
        this.saleOrderRepo.save((Model)this.fillSaleOrder(saleOrder, invoice));
        return invoice;
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateInvoice(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLinesSelected) throws AxelorException {
        Invoice invoice = this.createInvoice(saleOrder, saleOrderLinesSelected);
        ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)invoice);
        this.saleOrderRepo.save((Model)this.fillSaleOrder(saleOrder, invoice));
        return invoice;
    }

    public BigDecimal computeInTaxTotalInvoiced(Invoice invoice) {
        BigDecimal total = BigDecimal.ZERO;
        if (invoice.getStatusSelect() == 3) {
            if (invoice.getOperationTypeSelect() == 3) {
                total = total.add(invoice.getInTaxTotal());
            }
            if (invoice.getOperationTypeSelect() == 4) {
                total = total.subtract(invoice.getInTaxTotal());
            }
        }
        if (invoice.getRefundInvoiceList() != null) {
            for (Invoice refund : invoice.getRefundInvoiceList()) {
                total = total.add(this.computeInTaxTotalInvoiced(refund));
            }
        }
        return total;
    }

    @Override
    public SaleOrder fillSaleOrder(SaleOrder saleOrder, Invoice invoice) {
        saleOrder.setOrderDate(this.today);
        return saleOrder;
    }

    @Override
    public Invoice createInvoice(SaleOrder saleOrder) throws AxelorException {
        return this.createInvoice(saleOrder, saleOrder.getSaleOrderLineList());
    }

    @Override
    public Invoice createInvoice(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLineList) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(saleOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, saleOrderLineList));
        this.log.debug("fillAdvancePayment : methode termin\u00e9e");
        this.fillInLines(invoice);
        return invoice;
    }

    @Override
    public InvoiceGenerator createInvoiceGenerator(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getCurrency() == null) {
            throw new AxelorException(String.format(I18n.get((String)"Please, select a currency for the order %s"), saleOrder.getSaleOrderSeq()), 4, new Object[0]);
        }
        InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(saleOrder){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        return invoiceGenerator;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<SaleOrderLine> saleOrderLineList) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            if ("subscriptable".equals(saleOrderLine.getProduct().getProductTypeSelect())) continue;
            invoiceLineList.addAll(this.createInvoiceLine(invoice, saleOrderLine));
            saleOrderLine.setInvoiced(true);
        }
        return invoiceLineList;
    }

    public List<InvoiceLine> createSubscriptionInvoiceLines(Invoice invoice, List<Subscription> subscriptionList) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int sequence = 1;
        for (Subscription subscription : subscriptionList) {
            invoiceLineList.addAll(this.createSubscriptionInvoiceLine(invoice, subscription, sequence));
            subscription.setInvoiced(true);
            ++sequence;
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, SaleOrderLine saleOrderLine) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, saleOrderLine.getProductName(), saleOrderLine.getDescription(), saleOrderLine.getQty(), saleOrderLine.getUnit(), saleOrderLine.getSequence(), false, saleOrderLine, null, null, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    public List<InvoiceLine> createSubscriptionInvoiceLine(Invoice invoice, Subscription subscription, Integer sequence) throws AxelorException {
        SaleOrderLine saleOrderLine = subscription.getSaleOrderLine();
        Product product = saleOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, saleOrderLine.getProductName() + "(" + saleOrderLine.getPeriodicity() + " " + I18n.get((String)"month(s)") + ")", saleOrderLine.getDescription(), saleOrderLine.getQty(), saleOrderLine.getUnit(), sequence, false, saleOrderLine, null, null, subscription){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                invoiceLine.setSubscriptionFromDate(this.subscription.getFromPeriodDate());
                invoiceLine.setSubscriptionToDate(this.subscription.getToPeriodDate());
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Override
    public BigDecimal getInvoicedAmount(SaleOrder saleOrder) {
        return this.getInvoicedAmount(saleOrder, null, true);
    }

    @Override
    public BigDecimal getInvoicedAmount(SaleOrder saleOrder, Long currentInvoiceId, boolean excludeCurrentInvoice) {
        BigDecimal invoicedAmount = BigDecimal.ZERO;
        BigDecimal saleAmount = this.getAmountVentilated(saleOrder, currentInvoiceId, excludeCurrentInvoice, 3);
        BigDecimal refundAmount = this.getAmountVentilated(saleOrder, currentInvoiceId, excludeCurrentInvoice, 4);
        if (saleAmount != null) {
            invoicedAmount = invoicedAmount.add(saleAmount);
        }
        if (refundAmount != null) {
            invoicedAmount = invoicedAmount.subtract(refundAmount);
        }
        if (!saleOrder.getCurrency().equals((Object)saleOrder.getCompany().getCurrency()) && saleOrder.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = invoicedAmount.divide(saleOrder.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmount = saleOrder.getExTaxTotal().multiply(rate);
        }
        this.log.debug("Compute the invoiced amount ({}) of the sale order : {}", (Object)invoicedAmount, (Object)saleOrder.getSaleOrderSeq());
        return invoicedAmount;
    }

    private BigDecimal getAmountVentilated(SaleOrder saleOrder, Long currentInvoiceId, boolean excludeCurrentInvoice, int invoiceOperationTypeSelect) {
        BigDecimal invoicedAmount;
        String query = "SELECT SUM(self.companyExTaxTotal) FROM InvoiceLine as self WHERE (self.saleOrderLine.saleOrder.id = :saleOrderId OR self.saleOrder.id = :saleOrderId ) AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect AND self.invoice.statusSelect = :statusVentilated";
        if (currentInvoiceId != null) {
            query = excludeCurrentInvoice ? query + " AND self.invoice.id <> :invoiceId" : query + " OR (self.invoice.id = :invoiceId AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect) ";
        }
        TypedQuery q = JPA.em().createQuery(query, BigDecimal.class);
        q.setParameter("saleOrderId", (Object)saleOrder.getId());
        q.setParameter("statusVentilated", (Object)3);
        q.setParameter("invoiceOperationTypeSelect", (Object)invoiceOperationTypeSelect);
        if (currentInvoiceId != null) {
            q.setParameter("invoiceId", (Object)currentInvoiceId);
        }
        if ((invoicedAmount = (BigDecimal)q.getSingleResult()) != null) {
            return invoicedAmount;
        }
        return BigDecimal.ZERO;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateSubscriptionInvoice(List<Subscription> subscriptionList, SaleOrder saleOrder) throws AxelorException {
        if (subscriptionList == null || subscriptionList.isEmpty()) {
            return null;
        }
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(saleOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createSubscriptionInvoiceLines(invoice, subscriptionList));
        this.fillInLines(invoice);
        invoice.setIsSubscription(true);
        ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)invoice);
        return invoice;
    }

    @Override
    public void fillInLines(Invoice invoice) {
        List<InvoiceLine> invoiceLineList = invoice.getInvoiceLineList();
        if (invoiceLineList != null) {
            for (InvoiceLine invoiceLine : invoiceLineList) {
                invoiceLine.setSaleOrder(invoice.getSaleOrder());
            }
        }
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateSubcriptionInvoiceForSaleOrder(SaleOrder saleOrder) throws AxelorException {
        List subscriptionList = ((SubscriptionRepository)((Object)Beans.get(SubscriptionRepository.class))).all().filter("self.invoicingDate <= ?1 AND self.saleOrderLine.saleOrder.id = ?2 AND self.invoiced = false", new Object[]{this.generalService.getTodayDate(), saleOrder.getId()}).fetch();
        if (subscriptionList != null && !subscriptionList.isEmpty()) {
            return this.generateSubscriptionInvoice(subscriptionList, saleOrder);
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateSubcriptionInvoiceForSaleOrderAndListSubscrip(Long saleOrderId, List<Long> subscriptionIdList) throws AxelorException {
        List subscriptionList = ((SubscriptionRepository)((Object)Beans.get(SubscriptionRepository.class))).all().filter("self.id IN (:subscriptionIds)").bind("subscriptionIds", subscriptionIdList).fetch();
        if (subscriptionList != null && !subscriptionList.isEmpty()) {
            return this.generateSubscriptionInvoice(subscriptionList, (SaleOrder)this.saleOrderRepo.find(saleOrderId));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateSubcriptionInvoiceForSaleOrderLine(SaleOrderLine saleOrderLine) throws AxelorException {
        List subscriptionList = ((SubscriptionRepository)((Object)Beans.get(SubscriptionRepository.class))).all().filter("self.invoicingDate <= ?1 AND self.saleOrderLine.id = ?2 AND self.invoiced = false", new Object[]{this.generalService.getTodayDate(), saleOrderLine.getId()}).fetch();
        if (subscriptionList != null && !subscriptionList.isEmpty()) {
            return this.generateSubscriptionInvoice(subscriptionList, saleOrderLine.getSaleOrder());
        }
        return null;
    }

    @Override
    @Transactional
    public Invoice mergeInvoice(List<Invoice> invoiceList, Company company, Currency currency, Partner partner, Partner contactPartner, PriceList priceList, PaymentMode paymentMode, PaymentCondition paymentCondition, SaleOrder saleOrder) throws AxelorException {
        this.log.debug("service supplychain 1 (saleOrder) {}", (Object)saleOrder);
        if (saleOrder != null) {
            String numSeq = "";
            String externalRef = "";
            for (Invoice invoiceLocal : invoiceList) {
                if (!numSeq.isEmpty()) {
                    numSeq = numSeq + "-";
                }
                if (invoiceLocal.getInternalReference() != null) {
                    numSeq = numSeq + invoiceLocal.getInternalReference();
                }
                if (!externalRef.isEmpty()) {
                    externalRef = externalRef + "|";
                }
                if (invoiceLocal.getExternalReference() == null) continue;
                externalRef = externalRef + invoiceLocal.getExternalReference();
            }
            InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(saleOrder);
            Invoice invoiceMerged = invoiceGenerator.generate();
            invoiceMerged.setExternalReference(externalRef);
            invoiceMerged.setInternalReference(numSeq);
            if (paymentMode != null) {
                invoiceMerged.setPaymentMode(paymentMode);
            }
            if (paymentCondition != null) {
                invoiceMerged.setPaymentCondition(paymentCondition);
            }
            List invoiceLines = this.invoiceService.getInvoiceLinesFromInvoiceList(invoiceList);
            invoiceGenerator.populate(invoiceMerged, invoiceLines);
            this.invoiceService.setInvoiceForInvoiceLines(invoiceLines, invoiceMerged);
            if (!this.generalService.getGeneral().getManageInvoicedAmountByLine().booleanValue()) {
                this.fillInLines(invoiceMerged);
            } else {
                invoiceMerged.setSaleOrder(null);
            }
            ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)invoiceMerged);
            this.invoiceService.deleteOldInvoices(invoiceList);
            return invoiceMerged;
        }
        if (!this.generalService.getGeneral().getManageInvoicedAmountByLine().booleanValue()) {
            Invoice invoiceMerged = this.invoiceService.mergeInvoice(invoiceList, company, currency, partner, contactPartner, priceList, paymentMode, paymentCondition);
            this.fillInLines(invoiceMerged);
            return invoiceMerged;
        }
        return this.invoiceService.mergeInvoice(invoiceList, company, currency, partner, contactPartner, priceList, paymentMode, paymentCondition);
    }
}

