/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.service.AnalyticDistributionLineService;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.SaleOrderLineServiceImpl;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderLineServiceSupplyChainImpl
extends SaleOrderLineServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SaleOrderLineServiceSupplyChainImpl.class);
    @Inject
    protected GeneralService generalService;
    @Inject
    protected AnalyticDistributionLineService analyticDistributionLineService;

    public BigDecimal computeAmount(SaleOrderLine saleOrderLine) {
        BigDecimal price = this.computeDiscount(saleOrderLine);
        BigDecimal amount = saleOrderLine.getQty().multiply(price).setScale(2, RoundingMode.HALF_EVEN);
        if ("subscriptable".equals(saleOrderLine.getProduct().getProductTypeSelect())) {
            amount = saleOrderLine.getSubscriptionList() != null && !saleOrderLine.getSubscriptionList().isEmpty() ? amount.multiply(new BigDecimal(saleOrderLine.getSubscriptionList().size())).setScale(2, RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
        }
        LOG.debug("Calcul du montant HT avec une quantit\u00e9 de {} pour {} : {}", new Object[]{saleOrderLine.getQty(), price, amount});
        return amount;
    }

    public SaleOrderLine computeAnalyticDistribution(SaleOrderLine saleOrderLine) throws AxelorException {
        List analyticDistributionLineList = saleOrderLine.getAnalyticDistributionLineList();
        if ((analyticDistributionLineList == null || analyticDistributionLineList.isEmpty()) && this.generalService.getGeneral().getAnalyticDistributionTypeSelect() != 1 && (analyticDistributionLineList = this.analyticDistributionLineService.generateLines(saleOrderLine.getSaleOrder().getClientPartner(), saleOrderLine.getProduct(), saleOrderLine.getSaleOrder().getCompany(), saleOrderLine.getExTaxTotal())) != null) {
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                analyticDistributionLine.setSaleOrderLine(saleOrderLine);
                analyticDistributionLine.setAmount(this.analyticDistributionLineService.computeAmount(analyticDistributionLine));
                analyticDistributionLine.setDate(this.generalService.getTodayDate());
            }
            saleOrderLine.setAnalyticDistributionLineList(analyticDistributionLineList);
        }
        if (analyticDistributionLineList != null && this.generalService.getGeneral().getAnalyticDistributionTypeSelect() != 1) {
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                analyticDistributionLine.setSaleOrderLine(saleOrderLine);
                analyticDistributionLine.setAmount(this.analyticDistributionLineService.computeAmount(analyticDistributionLine));
                analyticDistributionLine.setDate(this.generalService.getTodayDate());
            }
        }
        return saleOrderLine;
    }

    public SaleOrderLine createAnalyticDistributionWithTemplate(SaleOrderLine saleOrderLine) throws AxelorException {
        List analyticDistributionLineList = null;
        analyticDistributionLineList = this.analyticDistributionLineService.generateLinesWithTemplate(saleOrderLine.getAnalyticDistributionTemplate(), saleOrderLine.getExTaxTotal());
        if (analyticDistributionLineList != null) {
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                analyticDistributionLine.setSaleOrderLine(saleOrderLine);
            }
        }
        saleOrderLine.setAnalyticDistributionLineList(analyticDistributionLineList);
        return saleOrderLine;
    }
}

