/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseConfig;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseConfigRepository;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.supplychain.service.PurchaseOrderLineServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderPurchaseServiceImpl
implements SaleOrderPurchaseService {
    private static final Logger LOG = LoggerFactory.getLogger(SaleOrderPurchaseServiceImpl.class);
    @Inject
    private PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    @Inject
    protected PurchaseOrderLineServiceSupplychainImpl purchaseOrderLineServiceSupplychainImpl;
    @Inject
    protected GeneralService generalService;
    protected LocalDate today = ((GeneralService)Beans.get(GeneralService.class)).getTodayDate();
    protected User user = AuthUtils.getUser();

    @Inject
    public SaleOrderPurchaseServiceImpl() {
    }

    @Override
    public void createPurchaseOrders(SaleOrder saleOrder) throws AxelorException {
        Map<Partner, List<SaleOrderLine>> saleOrderLinesBySupplierPartner = this.splitBySupplierPartner(saleOrder.getSaleOrderLineList());
        for (Partner supplierPartner : saleOrderLinesBySupplierPartner.keySet()) {
            this.createPurchaseOrder(supplierPartner, saleOrderLinesBySupplierPartner.get((Object)supplierPartner), saleOrder);
        }
    }

    @Override
    public Map<Partner, List<SaleOrderLine>> splitBySupplierPartner(List<SaleOrderLine> saleOrderLineList) throws AxelorException {
        HashMap<Partner, List<SaleOrderLine>> saleOrderLinesBySupplierPartner = new HashMap<Partner, List<SaleOrderLine>>();
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            if (saleOrderLine.getSaleSupplySelect() != 2) continue;
            Partner supplierPartner = saleOrderLine.getSupplierPartner();
            if (supplierPartner == null) {
                throw new AxelorException(String.format(I18n.get((String)"Please, select a supplier for the line %s"), saleOrderLine.getProductName()), 4, new Object[0]);
            }
            if (!saleOrderLinesBySupplierPartner.containsKey((Object)supplierPartner)) {
                saleOrderLinesBySupplierPartner.put(supplierPartner, new ArrayList());
            }
            ((List)saleOrderLinesBySupplierPartner.get((Object)supplierPartner)).add(saleOrderLine);
        }
        return saleOrderLinesBySupplierPartner;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public PurchaseOrder createPurchaseOrder(Partner supplierPartner, List<SaleOrderLine> saleOrderLineList, SaleOrder saleOrder) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une commande fournisseur pour le devis client : {}", new Object[]{saleOrder.getSaleOrderSeq()});
        PurchaseOrder purchaseOrder = this.purchaseOrderServiceSupplychainImpl.createPurchaseOrder(this.user, saleOrder.getCompany(), null, supplierPartner.getCurrency(), null, saleOrder.getSaleOrderSeq(), saleOrder.getExternalReference(), this.purchaseOrderServiceSupplychainImpl.getLocation(saleOrder.getCompany()), this.today, supplierPartner.getPurchasePriceList(), supplierPartner);
        Integer atiChoice = ((PurchaseConfig)((PurchaseConfigRepository)Beans.get(PurchaseConfigRepository.class)).all().filter("self.company = ?1", new Object[]{saleOrder.getCompany()}).fetchOne()).getPurchaseOrderInAtiSelect();
        if (atiChoice == 2 || atiChoice == 4) {
            purchaseOrder.setInAti(true);
        } else {
            purchaseOrder.setInAti(false);
        }
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            purchaseOrder.addPurchaseOrderLineListItem(this.purchaseOrderLineServiceSupplychainImpl.createPurchaseOrderLine(purchaseOrder, saleOrderLine));
        }
        this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
        ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).save((Model)purchaseOrder);
        return purchaseOrder;
    }
}

