/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.LocationRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;

public class SaleOrderStockServiceImpl
implements SaleOrderStockService {
    protected StockMoveService stockMoveService;
    protected StockMoveLineService stockMoveLineService;
    protected StockConfigService stockConfigService;
    protected LocationRepository locationRepo;
    protected StockMoveRepository stockMoveRepo;
    protected UnitConversionService unitConversionService;

    @Inject
    public SaleOrderStockServiceImpl(StockMoveService stockMoveService, StockMoveLineService stockMoveLineService, StockConfigService stockConfigService, LocationRepository locationRepo, StockMoveRepository stockMoveRepo, UnitConversionService unitConversionService) {
        this.stockMoveService = stockMoveService;
        this.stockMoveLineService = stockMoveLineService;
        this.stockConfigService = stockConfigService;
        this.locationRepo = locationRepo;
        this.stockMoveRepo = stockMoveRepo;
        this.unitConversionService = unitConversionService;
    }

    @Override
    public Location getLocation(Company company) {
        return (Location)this.locationRepo.all().filter("self.company = ?1 and self.isDefaultLocation = ?2 and self.typeSelect = ?3", new Object[]{company, true, 1}).fetchOne();
    }

    @Override
    public StockMove createStocksMovesFromSaleOrder(SaleOrder saleOrder) throws AxelorException {
        if (this.existActiveStockMoveForSaleOrder(saleOrder)) {
            throw new AxelorException(String.format(I18n.get((String)"An active stock move already exists for the sale order %s"), saleOrder.getSaleOrderSeq()), 4, new Object[0]);
        }
        Company company = saleOrder.getCompany();
        if (saleOrder.getSaleOrderLineList() != null && company != null) {
            StockMove stockMove = this.createStockMove(saleOrder, company);
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                if (saleOrderLine.getProduct() == null && !saleOrderLine.getIsTitleLine().booleanValue()) continue;
                this.createStockMoveLine(stockMove, saleOrderLine, company);
            }
            if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
                stockMove.setExTaxTotal(this.stockMoveService.compute(stockMove));
                this.stockMoveService.plan(stockMove);
                return stockMove;
            }
        }
        return null;
    }

    @Override
    public StockMove createStockMove(SaleOrder saleOrder, Company company) throws AxelorException {
        Location toLocation = (Location)this.locationRepo.all().filter("self.isDefaultLocation = true and self.company = ?1 and self.typeSelect = ?2", new Object[]{company, 2}).fetchOne();
        if (toLocation == null) {
            toLocation = this.stockConfigService.getCustomerVirtualLocation(this.stockConfigService.getStockConfig(company));
        }
        StockMove stockMove = this.stockMoveService.createStockMove(null, saleOrder.getDeliveryAddress(), company, saleOrder.getClientPartner(), saleOrder.getLocation(), toLocation, saleOrder.getShipmentDate(), saleOrder.getDescription());
        stockMove.setSaleOrder(saleOrder);
        stockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
        return stockMove;
    }

    @Override
    public StockMoveLine createStockMoveLine(StockMove stockMove, SaleOrderLine saleOrderLine, Company company) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        if (product != null && this.isStockMoveProduct(saleOrderLine) && !"subscriptable".equals(product.getProductTypeSelect())) {
            Unit unit = saleOrderLine.getProduct().getUnit();
            BigDecimal qty = saleOrderLine.getQty();
            BigDecimal priceDiscounted = saleOrderLine.getPriceDiscounted();
            if (!unit.equals((Object)saleOrderLine.getUnit())) {
                qty = this.unitConversionService.convertWithProduct(saleOrderLine.getUnit(), unit, qty, saleOrderLine.getProduct());
                priceDiscounted = this.unitConversionService.convertWithProduct(saleOrderLine.getUnit(), unit, priceDiscounted, saleOrderLine.getProduct());
            }
            BigDecimal taxRate = BigDecimal.ZERO;
            TaxLine taxLine = saleOrderLine.getTaxLine();
            if (taxLine != null) {
                taxRate = taxLine.getValue();
            }
            StockMoveLine stockMoveLine = this.stockMoveLineService.createStockMoveLine(product, saleOrderLine.getProductName(), saleOrderLine.getDescription(), qty, priceDiscounted, unit, stockMove, 1, saleOrderLine.getSaleOrder().getInAti().booleanValue(), taxRate);
            stockMoveLine.setSaleOrderLine(saleOrderLine);
            if (stockMoveLine != null) {
                stockMove.addStockMoveLineListItem(stockMoveLine);
            }
            return stockMoveLine;
        }
        if (saleOrderLine.getIsTitleLine().booleanValue()) {
            StockMoveLine stockMoveLine = this.stockMoveLineService.createStockMoveLine(null, saleOrderLine.getProductName(), saleOrderLine.getDescription(), BigDecimal.ZERO, BigDecimal.ZERO, null, stockMove, 1, saleOrderLine.getSaleOrder().getInAti().booleanValue(), null);
            stockMoveLine.setSaleOrderLine(saleOrderLine);
            if (stockMoveLine != null) {
                stockMove.addStockMoveLineListItem(stockMoveLine);
            }
            return stockMoveLine;
        }
        return null;
    }

    @Override
    public boolean isStockMoveProduct(SaleOrderLine saleOrderLine) throws AxelorException {
        Company company = saleOrderLine.getSaleOrder().getCompany();
        StockConfig stockConfig = this.stockConfigService.getStockConfig(company);
        Product product = saleOrderLine.getProduct();
        return product != null && ("service".equals(product.getProductTypeSelect()) && stockConfig.getHasOutSmForNonStorableProduct() != false || "storable".equals(product.getProductTypeSelect()) && stockConfig.getHasOutSmForStorableProduct() != false);
    }

    @Override
    public boolean existActiveStockMoveForSaleOrder(SaleOrder saleOrder) {
        long nbStockMove = this.stockMoveRepo.all().filter("self.saleOrder = ? AND self.statusSelect <> ?", new Object[]{saleOrder, 4}).count();
        return nbStockMove > 0L;
    }
}

