/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.Map;

public interface StockMoveInvoiceService {
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice createInvoiceFromSaleOrder(StockMove var1, SaleOrder var2) throws AxelorException;

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice createInvoiceFromPurchaseOrder(StockMove var1, PurchaseOrder var2) throws AxelorException;

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice createInvoiceFromStockMove(StockMove var1) throws AxelorException;

    @Transactional
    public Map<String, Object> createInvoiceFromMultiOutgoingStockMove(List<StockMove> var1, PaymentCondition var2, PaymentMode var3, Partner var4) throws AxelorException;

    @Transactional
    public Map<String, Object> createInvoiceFromMultiIncomingStockMove(List<StockMove> var1, Partner var2) throws AxelorException;

    public Invoice extendInternalReference(StockMove var1, Invoice var2);

    public List<InvoiceLine> createInvoiceLines(Invoice var1, List<StockMoveLine> var2) throws AxelorException;

    public List<InvoiceLine> createInvoiceLine(Invoice var1, StockMoveLine var2) throws AxelorException;
}

