/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StockMoveInvoiceServiceImpl
implements StockMoveInvoiceService {
    @Inject
    private SaleOrderInvoiceService saleOrderInvoiceService;
    @Inject
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;
    @Inject
    private InvoiceRepository invoiceRepository;
    @Inject
    private StockMoveRepository stockMoveRepo;

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice createInvoiceFromSaleOrder(StockMove stockMove, SaleOrder saleOrder) throws AxelorException {
        if (stockMove.getInvoice() != null && stockMove.getInvoice().getStatusSelect() != 4) {
            throw new AxelorException(String.format(I18n.get((String)"An invoice not canceled already exists for the outgoing stock move %s"), stockMove.getName()), 4, new Object[0]);
        }
        InvoiceGenerator invoiceGenerator = this.saleOrderInvoiceService.createInvoiceGenerator(saleOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove.getStockMoveLineList()));
        if (invoice != null) {
            this.saleOrderInvoiceService.fillInLines(invoice);
            this.extendInternalReference(stockMove, invoice);
            this.invoiceRepository.save((Model)invoice);
            stockMove.setInvoice(invoice);
            this.stockMoveRepo.save((Model)stockMove);
        }
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice createInvoiceFromPurchaseOrder(StockMove stockMove, PurchaseOrder purchaseOrder) throws AxelorException {
        if (stockMove.getInvoice() != null && stockMove.getInvoice().getStatusSelect() != 4) {
            throw new AxelorException(String.format(I18n.get((String)"An invoice not canceled already exists for the incoming stock move %s"), stockMove.getName()), 4, new Object[0]);
        }
        InvoiceGenerator invoiceGenerator = this.purchaseOrderInvoiceService.createInvoiceGenerator(purchaseOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove.getStockMoveLineList()));
        if (invoice != null) {
            this.extendInternalReference(stockMove, invoice);
            this.invoiceRepository.save((Model)invoice);
            stockMove.setInvoice(invoice);
            this.stockMoveRepo.save((Model)stockMove);
        }
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice createInvoiceFromStockMove(StockMove stockMove) throws AxelorException {
        int invoiceOperationType;
        int stockMoveType = stockMove.getTypeSelect();
        Invoice invoice = stockMove.getInvoice();
        if (stockMoveType == 3) {
            invoiceOperationType = 1;
        } else if (stockMoveType == 2) {
            invoiceOperationType = 3;
        } else {
            return null;
        }
        if (invoice != null && invoice.getStatusSelect() != 4) {
            if (stockMoveType == 3) {
                throw new AxelorException(String.format(I18n.get((String)"An invoice not canceled already exists for the incoming stock move %s"), stockMove.getName()), 4, new Object[0]);
            }
            throw new AxelorException(String.format(I18n.get((String)"An invoice not canceled already exists for the outgoing stock move %s"), stockMove.getName()), 4, new Object[0]);
        }
        InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(stockMove, invoiceOperationType){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove.getStockMoveLineList()));
        if (invoice != null) {
            this.saleOrderInvoiceService.fillInLines(invoice);
            this.extendInternalReference(stockMove, invoice);
            this.invoiceRepository.save((Model)invoice);
            stockMove.setInvoice(invoice);
            this.stockMoveRepo.save((Model)stockMove);
        }
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Map<String, Object> createInvoiceFromMultiOutgoingStockMove(List<StockMove> stockMoveList, PaymentCondition paymentConditionIn, PaymentMode paymentModeIn, Partner contactPartnerIn) throws AxelorException {
        Currency invoiceCurrency = null;
        Partner invoiceClientPartner = null;
        Company invoiceCompany = null;
        PaymentCondition invoicePaymentCondition = null;
        PaymentMode invoicePaymentMode = null;
        Address invoiceMainInvoicingAddress = null;
        Partner invoiceContactPartner = null;
        PriceList invoicePriceList = null;
        Boolean invoiceInAti = null;
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        int count = 1;
        ArrayList<StockMove> stockMoveToInvoiceList = new ArrayList<StockMove>();
        String message = "";
        for (StockMove stockMove : stockMoveList) {
            if (stockMove.getInvoice() != null && stockMove.getInvoice().getStatusSelect() != 4) {
                message = String.format(I18n.get((String)"An invoice not canceled already exists for the outgoing stock move %s"), stockMove.getName());
                if (mapResult.get("information") != null) {
                    message = mapResult.get("information") + "<br/>" + message;
                }
                mapResult.put("information", message);
                continue;
            }
            SaleOrder saleOrder = stockMove.getSaleOrder();
            if (count == 1) {
                invoiceCurrency = saleOrder.getCurrency();
                invoiceClientPartner = saleOrder.getClientPartner();
                invoiceCompany = saleOrder.getCompany();
                invoicePaymentCondition = saleOrder.getPaymentCondition();
                invoicePaymentMode = saleOrder.getPaymentMode();
                invoiceMainInvoicingAddress = saleOrder.getMainInvoicingAddress();
                invoiceContactPartner = saleOrder.getContactPartner();
                invoicePriceList = saleOrder.getPriceList();
                invoiceInAti = saleOrder.getInAti();
            } else {
                if (invoiceCurrency != null && !invoiceCurrency.equals((Object)saleOrder.getCurrency())) {
                    invoiceCurrency = null;
                }
                if (invoiceClientPartner != null && !invoiceClientPartner.equals((Object)saleOrder.getClientPartner())) {
                    invoiceClientPartner = null;
                }
                if (invoiceCompany != null && !invoiceCompany.equals((Object)saleOrder.getCompany())) {
                    invoiceCompany = null;
                }
                if (invoicePaymentCondition != null && !invoicePaymentCondition.equals((Object)saleOrder.getPaymentCondition())) {
                    invoicePaymentCondition = null;
                }
                if (invoicePaymentMode != null && !invoicePaymentMode.equals((Object)saleOrder.getPaymentMode())) {
                    invoicePaymentMode = null;
                }
                if (invoiceMainInvoicingAddress != null && !invoiceMainInvoicingAddress.equals((Object)saleOrder.getMainInvoicingAddress())) {
                    invoiceMainInvoicingAddress = null;
                }
                if (invoiceContactPartner != null && !invoiceContactPartner.equals((Object)saleOrder.getContactPartner())) {
                    invoiceContactPartner = null;
                }
                if (invoicePriceList != null && !invoicePriceList.equals((Object)saleOrder.getPriceList())) {
                    invoicePriceList = null;
                }
                if (invoiceInAti != null && !invoiceInAti.equals(saleOrder.getInAti())) {
                    invoiceInAti = null;
                }
            }
            stockMoveToInvoiceList.add(stockMove);
            ++count;
        }
        if (stockMoveToInvoiceList.isEmpty()) {
            return mapResult;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (invoiceCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all sale orders"));
        }
        if (invoiceClientPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The client Partner is required and must be the same for all sale orders"));
        }
        if (invoiceCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all sale orders"));
        }
        if (invoiceInAti == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"Unit prices in A.T.I and in W.T. can't be mix"));
        }
        if (fieldErrors.length() > 0) {
            throw new AxelorException(fieldErrors.toString(), 4, new Object[0]);
        }
        if (invoicePaymentCondition == null) {
            if (paymentConditionIn != null) {
                invoicePaymentCondition = paymentConditionIn;
            } else {
                mapResult.put("paymentConditionToCheck", true);
            }
        }
        if (invoicePaymentMode == null) {
            if (paymentModeIn != null) {
                invoicePaymentMode = paymentModeIn;
            } else {
                mapResult.put("paymentModeToCheck", true);
            }
        }
        if (invoiceContactPartner == null) {
            if (contactPartnerIn != null) {
                invoiceContactPartner = contactPartnerIn;
            } else {
                mapResult.put("contactPartnerToCheck", true);
                mapResult.put("partnerId", invoiceClientPartner.getId());
            }
        }
        if (!mapResult.isEmpty()) {
            return mapResult;
        }
        if (invoiceMainInvoicingAddress == null) {
            invoiceMainInvoicingAddress = ((PartnerService)Beans.get(PartnerService.class)).getInvoicingAddress(invoiceClientPartner);
        }
        if (invoicePriceList == null) {
            invoicePriceList = invoiceClientPartner.getSalePriceList();
        }
        String numSeq = "";
        String internalRef = "";
        String externalRef = "";
        ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
        for (StockMove stockMoveLocal : stockMoveToInvoiceList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + stockMoveLocal.getSaleOrder().getSaleOrderSeq();
            if (!internalRef.isEmpty()) {
                internalRef = internalRef + "|";
            }
            internalRef = internalRef + stockMoveLocal.getStockMoveSeq() + ":" + stockMoveLocal.getSaleOrder().getSaleOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (stockMoveLocal.getSaleOrder().getExternalReference() != null) {
                externalRef = externalRef + stockMoveLocal.getSaleOrder().getExternalReference();
            }
            stockMoveIdList.add(stockMoveLocal.getId());
        }
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(3, invoiceCompany, invoicePaymentCondition, invoicePaymentMode, invoiceMainInvoicingAddress, invoiceClientPartner, invoiceContactPartner, invoiceCurrency, invoicePriceList, numSeq, externalRef, null, null){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        invoice.setInternalReference(internalRef);
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (StockMove stockMoveLocal : stockMoveToInvoiceList) {
            invoiceLineList.addAll(this.createInvoiceLines(invoice, stockMoveLocal.getStockMoveLineList()));
        }
        invoiceGenerator.populate(invoice, invoiceLineList);
        if (invoice != null) {
            this.invoiceRepository.save((Model)invoice);
            JPA.all(StockMove.class).filter("self.id IN (:idStockMoveList)").bind("idStockMoveList", stockMoveIdList).update("invoice", (Object)invoice);
            mapResult.put("invoiceId", invoice.getId());
        }
        return mapResult;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Map<String, Object> createInvoiceFromMultiIncomingStockMove(List<StockMove> stockMoveList, Partner contactPartnerIn) throws AxelorException {
        Company invoiceCompany = null;
        Partner invoiceSupplierPartner = null;
        Partner invoiceContactPartner = null;
        PriceList invoicePriceList = null;
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        int count = 1;
        ArrayList<StockMove> stockMoveToInvoiceList = new ArrayList<StockMove>();
        String message = "";
        for (StockMove stockMove : stockMoveList) {
            if (stockMove.getInvoice() != null && stockMove.getInvoice().getStatusSelect() != 4) {
                message = String.format(I18n.get((String)"An invoice not canceled already exists for the incoming stock move %s"), stockMove.getName());
                if (mapResult.get("information") != null) {
                    message = mapResult.get("information") + "<br/>" + message;
                }
                mapResult.put("information", message);
                continue;
            }
            PurchaseOrder purchaseOrder = stockMove.getPurchaseOrder();
            if (count == 1) {
                invoiceCompany = purchaseOrder.getCompany();
                invoiceSupplierPartner = purchaseOrder.getSupplierPartner();
                invoiceContactPartner = purchaseOrder.getContactPartner();
                invoicePriceList = purchaseOrder.getPriceList();
            } else {
                if (invoiceCompany != null && !invoiceCompany.equals((Object)purchaseOrder.getCompany())) {
                    invoiceCompany = null;
                }
                if (invoiceSupplierPartner != null && !invoiceSupplierPartner.equals((Object)purchaseOrder.getSupplierPartner())) {
                    invoiceSupplierPartner = null;
                }
                if (invoiceContactPartner != null && !invoiceContactPartner.equals((Object)purchaseOrder.getContactPartner())) {
                    invoiceContactPartner = null;
                }
                if (invoicePriceList != null && !invoicePriceList.equals((Object)purchaseOrder.getPriceList())) {
                    invoicePriceList = null;
                }
            }
            stockMoveToInvoiceList.add(stockMove);
            ++count;
        }
        if (stockMoveToInvoiceList.isEmpty()) {
            return mapResult;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (invoiceSupplierPartner == null) {
            fieldErrors.append("The supplier Partner is required and must be the same for all purchase orders");
        }
        if (invoiceCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all purchase orders"));
        }
        if (fieldErrors.length() > 0) {
            throw new AxelorException(fieldErrors.toString(), 4, new Object[0]);
        }
        if (invoiceContactPartner == null) {
            if (contactPartnerIn != null) {
                invoiceContactPartner = contactPartnerIn;
            } else {
                mapResult.put("contactPartnerToCheck", true);
                mapResult.put("partnerId", invoiceSupplierPartner.getId());
            }
        }
        if (!mapResult.isEmpty()) {
            return mapResult;
        }
        if (invoicePriceList == null) {
            invoicePriceList = invoiceSupplierPartner.getPurchasePriceList();
        }
        String numSeq = "";
        String externalRef = "";
        ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
        for (StockMove stockMoveLocal : stockMoveToInvoiceList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + stockMoveLocal.getPurchaseOrder().getPurchaseOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (stockMoveLocal.getPurchaseOrder().getExternalReference() != null) {
                externalRef = externalRef + stockMoveLocal.getPurchaseOrder().getExternalReference();
            }
            stockMoveIdList.add(stockMoveLocal.getId());
        }
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(1, invoiceCompany, invoiceSupplierPartner, invoiceContactPartner, invoicePriceList, numSeq, externalRef, null){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (StockMove stockMoveLocal : stockMoveToInvoiceList) {
            invoiceLineList.addAll(this.createInvoiceLines(invoice, stockMoveLocal.getStockMoveLineList()));
        }
        invoiceGenerator.populate(invoice, invoiceLineList);
        if (invoice != null) {
            this.invoiceRepository.save((Model)invoice);
            JPA.all(StockMove.class).filter("self.id IN (:idStockMoveList)").bind("idStockMoveList", stockMoveIdList).update("invoice", (Object)invoice);
            mapResult.put("invoiceId", invoice.getId());
        }
        return mapResult;
    }

    @Override
    public Invoice extendInternalReference(StockMove stockMove, Invoice invoice) {
        invoice.setInternalReference(stockMove.getStockMoveSeq() + ":" + invoice.getInternalReference());
        return invoice;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            List<InvoiceLine> invoiceLineListCreated = this.createInvoiceLine(invoice, stockMoveLine);
            if (invoiceLineListCreated != null) {
                invoiceLineList.addAll(invoiceLineListCreated);
            }
            if (stockMoveLine.getSaleOrderLine() != null) {
                stockMoveLine.getSaleOrderLine().setInvoiced(true);
                continue;
            }
            if (stockMoveLine.getPurchaseOrderLine() == null) continue;
            stockMoveLine.getPurchaseOrderLine().setInvoiced(true);
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, StockMoveLine stockMoveLine) throws AxelorException {
        Product product = stockMoveLine.getProduct();
        boolean isTitleLine = false;
        int sequence = 0;
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
        if (saleOrderLine != null) {
            if (saleOrderLine.getIsTitleLine().booleanValue()) {
                isTitleLine = true;
            }
            sequence = saleOrderLine.getSequence();
        } else if (purchaseOrderLine != null) {
            if (purchaseOrderLine.getIsTitleLine().booleanValue()) {
                isTitleLine = true;
            }
            sequence = purchaseOrderLine.getSequence();
        }
        if (stockMoveLine.getRealQty().compareTo(BigDecimal.ZERO) == 0 && !isTitleLine) {
            return null;
        }
        if (product == null && !isTitleLine) {
            throw new AxelorException(String.format(I18n.get((String)"Incorrect product in the stock move %s"), stockMoveLine.getStockMove().getStockMoveSeq()), 4, new Object[0]);
        }
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, stockMoveLine.getProductName(), stockMoveLine.getDescription(), stockMoveLine.getRealQty(), stockMoveLine.getUnit(), sequence, false, stockMoveLine.getSaleOrderLine(), stockMoveLine.getPurchaseOrderLine(), stockMoveLine){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }
}

