/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.SupplierCatalog;
import com.axelor.apps.base.db.repo.SupplierCatalogRepository;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockMoveLineServiceImpl;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class StockMoveLineSupplychainServiceImpl
extends StockMoveLineServiceImpl {
    @Inject
    protected AccountManagementService accountManagementService;
    @Inject
    protected PriceListService priceListService;
    @Inject
    private ProductService productService;

    public StockMoveLine compute(StockMoveLine stockMoveLine, StockMove stockMove) throws AxelorException {
        BigDecimal unitPriceUntaxed = BigDecimal.ZERO;
        BigDecimal unitPriceTaxed = BigDecimal.ZERO;
        TaxLine taxLine = null;
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (stockMove == null || stockMove.getSaleOrder() == null && stockMove.getPurchaseOrder() == null) {
            return super.compute(stockMoveLine, stockMove);
        }
        if (stockMove.getSaleOrder() != null) {
            PriceListLine priceListLine;
            Map discounts;
            taxLine = this.accountManagementService.getTaxLine(this.generalService.getTodayDate(), stockMoveLine.getProduct(), stockMove.getCompany(), stockMove.getSaleOrder().getClientPartner().getFiscalPosition(), false);
            unitPriceUntaxed = stockMoveLine.getProduct().getSalePrice();
            PriceList priceList = stockMove.getSaleOrder().getPriceList();
            if (priceList != null && (discounts = this.priceListService.getDiscounts(priceList, priceListLine = this.priceListService.getPriceListLine(stockMoveLine.getProduct(), stockMoveLine.getQty(), priceList), unitPriceUntaxed)) != null) {
                discountAmount = (BigDecimal)discounts.get("discountAmount");
                unitPriceUntaxed = this.priceListService.computeDiscount(unitPriceUntaxed, ((Integer)discounts.get("discountTypeSelect")).intValue(), discountAmount);
            }
        } else {
            Map discounts;
            SupplierCatalog supplierCatalog;
            List<SupplierCatalog> supplierCatalogList;
            PriceListLine priceListLine;
            Map discounts2;
            taxLine = this.accountManagementService.getTaxLine(this.generalService.getTodayDate(), stockMoveLine.getProduct(), stockMove.getCompany(), stockMove.getPurchaseOrder().getSupplierPartner().getFiscalPosition(), true);
            unitPriceUntaxed = stockMoveLine.getProduct().getPurchasePrice();
            PriceList priceList = stockMove.getPurchaseOrder().getPriceList();
            if (priceList != null && (discounts2 = this.priceListService.getDiscounts(priceList, priceListLine = this.priceListService.getPriceListLine(stockMoveLine.getProduct(), stockMoveLine.getQty(), priceList), unitPriceUntaxed)) != null) {
                discountAmount = (BigDecimal)discounts2.get("discountAmount");
                unitPriceUntaxed = this.priceListService.computeDiscount(unitPriceUntaxed, ((Integer)discounts2.get("discountTypeSelect")).intValue(), discountAmount);
            }
            if (discountAmount.equals(BigDecimal.ZERO) && (supplierCatalogList = stockMoveLine.getProduct().getSupplierCatalogList()) != null && !supplierCatalogList.isEmpty() && (supplierCatalog = (SupplierCatalog)((SupplierCatalogRepository)Beans.get(SupplierCatalogRepository.class)).all().filter("self.product = ?1 AND self.minQty <= ?2 AND self.supplierPartner = ?3 ORDER BY self.minQty DESC", new Object[]{stockMoveLine.getProduct(), unitPriceUntaxed, stockMove.getPurchaseOrder().getSupplierPartner()}).fetchOne()) != null && (discounts = this.productService.getDiscountsFromCatalog(supplierCatalog, unitPriceUntaxed)) != null) {
                unitPriceUntaxed = this.priceListService.computeDiscount(unitPriceUntaxed, ((Integer)discounts.get("discountTypeSelect")).intValue(), (BigDecimal)discounts.get("discountAmount"));
            }
        }
        unitPriceTaxed = unitPriceUntaxed.multiply(taxLine.getValue().add(BigDecimal.ONE));
        stockMoveLine.setUnitPriceUntaxed(unitPriceUntaxed);
        stockMoveLine.setUnitPriceTaxed(unitPriceTaxed);
        return stockMoveLine;
    }
}

