/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.General;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderServiceImpl;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.SaleOrderServiceImpl;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockMoveServiceImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockMoveServiceSupplychainImpl
extends StockMoveServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StockMoveServiceSupplychainImpl.class);
    @Inject
    GeneralService generalService;

    public BigDecimal compute(StockMove stockMove) {
        BigDecimal exTaxTotal;
        block4: {
            exTaxTotal = BigDecimal.ZERO;
            if (stockMove.getStockMoveLineList() == null || stockMove.getStockMoveLineList().isEmpty()) break block4;
            if (stockMove.getSaleOrder() != null && stockMove.getSaleOrder().getInAti().booleanValue() || stockMove.getPurchaseOrder() != null && stockMove.getPurchaseOrder().getInAti().booleanValue()) {
                for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                    exTaxTotal = exTaxTotal.add(stockMoveLine.getRealQty().multiply(stockMoveLine.getUnitPriceTaxed()));
                }
            } else {
                for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                    exTaxTotal = exTaxTotal.add(stockMoveLine.getRealQty().multiply(stockMoveLine.getUnitPriceUntaxed()));
                }
            }
        }
        return exTaxTotal.setScale(2, RoundingMode.HALF_UP);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public String realize(StockMove stockMove) throws AxelorException {
        LOG.debug("R\u00e9alisation du mouvement de stock : {} ", new Object[]{stockMove.getStockMoveSeq()});
        String newStockSeq = super.realize(stockMove);
        General general = this.generalService.getGeneral();
        if (stockMove.getSaleOrder() != null) {
            SaleOrder saleOrder = stockMove.getSaleOrder();
            if (newStockSeq != null) {
                saleOrder.setDeliveryState(SaleOrderRepository.STATE_PARTIALLY_DELIVERED);
            } else {
                saleOrder.setDeliveryState(SaleOrderRepository.STATE_DELIVERED);
                if (general.getTerminateSaleOrderOnDelivery().booleanValue()) {
                    ((SaleOrderServiceImpl)Beans.get(SaleOrderServiceImpl.class)).finishSaleOrder(saleOrder);
                }
            }
            ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)saleOrder);
        } else if (stockMove.getPurchaseOrder() != null) {
            PurchaseOrder purchaseOrder = stockMove.getPurchaseOrder();
            if (newStockSeq != null) {
                purchaseOrder.setReceiptState(2);
            } else {
                purchaseOrder.setReceiptState(3);
                if (general.getTerminatePurchaseOrderOnReceipt().booleanValue()) {
                    ((PurchaseOrderServiceImpl)Beans.get(PurchaseOrderServiceImpl.class)).finishPurchaseOrder(purchaseOrder);
                }
            }
            ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).save((Model)purchaseOrder);
        }
        return newStockSeq;
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void computeProductWeightedAveragePrice(StockMove stockMove) {
    }
}

