/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.SaleOrderLineService;
import com.axelor.apps.sale.service.SaleOrderService;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceServiceImpl;
import com.axelor.apps.supplychain.service.SubscriptionService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;

public class SubscriptionServiceImpl
implements SubscriptionService {
    @Inject
    private SaleOrderLineService saleOrderLineService;
    @Inject
    protected SaleOrderInvoiceServiceImpl saleOrderInvoiceServiceImpl;
    @Inject
    private SaleOrderService saleOrderService;

    @Override
    @Transactional
    public SaleOrderLine generateSubscriptions(SaleOrderLine saleOrderLine) throws AxelorException {
        if (saleOrderLine.getToSubDate() == null) {
            throw new AxelorException(I18n.get((String)"Fied Date To is empty because fields periodicity, date from or number of periods are empty"), 1, new Object[0]);
        }
        for (int iterator = 0; iterator != saleOrderLine.getPeriodNumber(); ++iterator) {
            Subscription subscription = new Subscription();
            if (saleOrderLine.getSubscripInvTypeSelect() == SaleOrderRepository.SUBSCRIPTION_PERIOD_BEGINNING) {
                subscription.setInvoicingDate(saleOrderLine.getFromSubDate().plusMonths(saleOrderLine.getPeriodicity() * iterator));
            } else {
                subscription.setInvoicingDate(saleOrderLine.getFromSubDate().plusMonths(saleOrderLine.getPeriodicity() * (iterator + 1)).minusDays(1));
            }
            subscription.setFromPeriodDate(saleOrderLine.getFromSubDate().plusMonths(saleOrderLine.getPeriodicity() * iterator));
            subscription.setToPeriodDate(saleOrderLine.getFromSubDate().plusMonths(saleOrderLine.getPeriodicity() * (iterator + 1)).minusDays(1));
            subscription.setInvoiced(false);
            saleOrderLine.addSubscriptionListItem(subscription);
        }
        return saleOrderLine;
    }

    @Override
    @Transactional
    public SaleOrderLine generateSubscriptions(SaleOrderLine saleOrderLineIt, SaleOrder saleOrder) throws AxelorException {
        int iterator = 0;
        int oldLine = 0;
        if (saleOrderLineIt.getSubscriptionList() != null && !saleOrderLineIt.getSubscriptionList().isEmpty()) {
            oldLine = saleOrderLineIt.getSubscriptionList().size();
        }
        BigDecimal oldExTaxTotal = saleOrderLineIt.getExTaxTotal();
        BigDecimal oldInTaxTotal = saleOrderLineIt.getInTaxTotal();
        if (oldLine != 0) {
            oldExTaxTotal = oldExTaxTotal.divide(new BigDecimal(oldLine), 2, RoundingMode.HALF_UP);
            oldInTaxTotal = oldInTaxTotal.divide(new BigDecimal(oldLine), 2, RoundingMode.HALF_UP);
        }
        if (saleOrder.getToSubDate() == null) {
            throw new AxelorException(I18n.get((String)"Field Date To is empty because fields periodicity, date from or number of periods are empty"), 1, new Object[0]);
        }
        ArrayList<Subscription> subscriptionItList = new ArrayList<Subscription>(saleOrderLineIt.getSubscriptionList());
        for (Subscription subscription : subscriptionItList) {
            if (subscription.getInvoiced().booleanValue()) continue;
            saleOrderLineIt.removeSubscriptionListItem(subscription);
        }
        while (iterator != saleOrder.getPeriodNumber()) {
            Subscription subscription = new Subscription();
            if (saleOrder.getSubscripInvTypeSelect() == SaleOrderRepository.SUBSCRIPTION_PERIOD_BEGINNING) {
                subscription.setInvoicingDate(saleOrder.getFromSubDate().plusMonths(saleOrder.getPeriodicity() * iterator));
            } else {
                subscription.setInvoicingDate(saleOrder.getFromSubDate().plusMonths(saleOrder.getPeriodicity() * (iterator + 1)).minusDays(1));
            }
            subscription.setFromPeriodDate(saleOrder.getFromSubDate().plusMonths(saleOrder.getPeriodicity() * iterator));
            subscription.setToPeriodDate(saleOrder.getFromSubDate().plusMonths(saleOrder.getPeriodicity() * (iterator + 1)).minusDays(1));
            subscription.setInvoiced(false);
            saleOrderLineIt.addSubscriptionListItem(subscription);
            ++iterator;
        }
        BigDecimal totalLines = new BigDecimal(saleOrderLineIt.getSubscriptionList().size());
        if (totalLines.compareTo(BigDecimal.ZERO) != 0) {
            saleOrderLineIt.setExTaxTotal(oldExTaxTotal.multiply(totalLines));
            saleOrderLineIt.setInTaxTotal(oldInTaxTotal.multiply(totalLines));
        }
        saleOrderLineIt.setCompanyExTaxTotal(this.saleOrderLineService.getAmountInCompanyCurrency(saleOrderLineIt.getExTaxTotal(), saleOrder));
        saleOrderLineIt.setCompanyInTaxTotal(this.saleOrderLineService.getAmountInCompanyCurrency(saleOrderLineIt.getInTaxTotal(), saleOrder));
        ((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).save((Model)saleOrderLineIt);
        return saleOrderLineIt;
    }

    @Override
    @Transactional
    public void generateAllSubscriptions(SaleOrder saleOrder) throws AxelorException {
        for (SaleOrderLine saleOrderLineIt : saleOrder.getSaleOrderLineList()) {
            if (!saleOrderLineIt.getProduct().getProductTypeSelect().equals("subscriptable")) continue;
            this.generateSubscriptions(saleOrderLineIt, saleOrder);
        }
        saleOrder = this.saleOrderService.computeSaleOrder(saleOrder);
        ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)saleOrder);
    }
}

