/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TimetableService {
    public void updateTimetable(SaleOrder saleOrder) {
        if (saleOrder.getTimetableList() != null && !saleOrder.getTimetableList().isEmpty()) {
            List<Timetable> timetableList = saleOrder.getTimetableList();
            BigDecimal amountInvoiced = saleOrder.getAmountInvoiced();
            BigDecimal sum = BigDecimal.ZERO;
            for (Timetable timetable : timetableList) {
                if ((sum = sum.add(timetable.getAmount())).compareTo(amountInvoiced) > 0) {
                    timetable.setAmountToInvoice(sum.subtract(amountInvoiced));
                    continue;
                }
                timetable.setAmountToInvoice(BigDecimal.ZERO);
            }
        }
    }

    public void updateTimetable(PurchaseOrder purchaseOrder) {
        if (purchaseOrder.getTimetableList() != null && !purchaseOrder.getTimetableList().isEmpty()) {
            List<Timetable> timetableList = purchaseOrder.getTimetableList();
            BigDecimal amountInvoiced = purchaseOrder.getAmountInvoiced();
            BigDecimal sum = BigDecimal.ZERO;
            for (Timetable timetable : timetableList) {
                if ((sum = sum.add(timetable.getAmount())).compareTo(amountInvoiced) > 0) {
                    timetable.setAmountToInvoice(sum.subtract(amountInvoiced));
                    continue;
                }
                timetable.setAmountToInvoice(BigDecimal.ZERO);
            }
        }
    }

    public Invoice generateInvoice(Timetable timetable) throws AxelorException {
        if (timetable.getProduct() == null) {
            throw new AxelorException(I18n.get((String)"Select a product"), 4, new Object[0]);
        }
        if (timetable.getUnit() == null) {
            throw new AxelorException(I18n.get((String)"Select an unit"), 4, new Object[0]);
        }
        Invoice invoice = this.createInvoice(timetable);
        ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)invoice);
        return invoice;
    }

    public Invoice createInvoice(Timetable timetable) throws AxelorException {
        SaleOrder saleOrder = timetable.getSaleOrder();
        PurchaseOrder purchaseOrder = timetable.getPurchaseOrder();
        if (saleOrder != null) {
            if (saleOrder.getCurrency() == null) {
                throw new AxelorException(String.format(I18n.get((String)"Please, select a currency for the order %s"), saleOrder.getSaleOrderSeq()), 4, new Object[0]);
            }
            InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(saleOrder){

                public Invoice generate() throws AxelorException {
                    return super.createInvoiceHeader();
                }
            };
            Invoice invoice = invoiceGenerator.generate();
            invoiceGenerator.populate(invoice, this.createInvoiceLine(invoice, timetable));
            this.fillInLines(invoice);
            return invoice;
        }
        if (purchaseOrder != null) {
            if (purchaseOrder.getCurrency() == null) {
                throw new AxelorException(String.format(I18n.get((String)"Please, select a currency for the order %s"), purchaseOrder.getPurchaseOrderSeq()), 4, new Object[0]);
            }
            InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(purchaseOrder){

                public Invoice generate() throws AxelorException {
                    return super.createInvoiceHeader();
                }
            };
            Invoice invoice = invoiceGenerator.generate();
            invoiceGenerator.populate(invoice, this.createInvoiceLine(invoice, timetable));
            return invoice;
        }
        return null;
    }

    public void fillInLines(Invoice invoice) {
        List<InvoiceLine> invoiceLineList = invoice.getInvoiceLineList();
        for (InvoiceLine invoiceLine : invoiceLineList) {
            invoiceLine.setSaleOrder(invoice.getSaleOrder());
        }
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, Timetable timetable) throws AxelorException {
        Product product = timetable.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, timetable.getProductName(), timetable.getComments(), timetable.getQty(), timetable.getUnit(), 1, false, null, null, null, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }
}

