/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.batch.BatchStrategy;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchInvoicing
extends BatchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BatchInvoicing.class);
    @Inject
    private SaleOrderRepository saleOrderRepo;

    @Inject
    public BatchInvoicing(SaleOrderInvoiceService saleOrderInvoiceService) {
        super(saleOrderInvoiceService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        int i = 0;
        List saleOrderList = this.saleOrderRepo.all().filter("self.statusSelect = ?2 AND self.company = ?3", new Object[]{3, this.batch.getSaleBatch().getCompany()}).fetch();
        for (SaleOrder saleOrder : saleOrderList) {
            try {
                Invoice invoice = this.saleOrderInvoiceService.generateInvoice((SaleOrder)this.saleOrderRepo.find(saleOrder.getId()));
                if (invoice == null) continue;
                this.updateSaleOrder(saleOrder);
                LOG.debug("Facture cr\u00e9\u00e9e ({}) pour le devis {}", (Object)invoice.getInvoiceId(), (Object)saleOrder.getSaleOrderSeq());
                ++i;
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException(String.format(I18n.get((String)"Devis") + " %s", ((SaleOrder)this.saleOrderRepo.find(saleOrder.getId())).getSaleOrderSeq()), (Throwable)e, e.getcategory(), new Object[0]), (String)"invoice", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Exception)new Exception(String.format(I18n.get((String)"Devis") + " %s", ((SaleOrder)this.saleOrderRepo.find(saleOrder.getId())).getSaleOrderSeq()), e), (String)"invoice", (long)this.batch.getId());
                this.incrementAnomaly();
                LOG.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le devis {}", (Object)((SaleOrder)this.saleOrderRepo.find(saleOrder.getId())).getSaleOrderSeq());
            }
            finally {
                if (i % 10 != 0) continue;
                JPA.clear();
            }
        }
    }

    protected void stop() {
        String comment = I18n.get((String)"Compte rendu de g\u00e9n\u00e9ration de facture d'abonnement :\n");
        comment = comment + String.format("\t* %s " + I18n.get((String)"Order(s) processed") + "\n", this.batch.getDone());
        comment = comment + String.format(I18n.get((String)"\t* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

