/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.apps.supplychain.db.repo.SubscriptionRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;

public class BatchSubscription
extends AbstractBatch {
    protected String comment = "";
    @Inject
    protected SaleOrderInvoiceService saleOrderInvoiceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        List lateSubscriptionsList = ((SubscriptionRepository)((Object)Beans.get(SubscriptionRepository.class))).all().filter("self.invoicingDate <= now() AND self.invoiced = false").fetch();
        int i = 0;
        for (Subscription subscription : lateSubscriptionsList) {
            SaleOrderLine saleOrderLine = subscription.getSaleOrderLine();
            SaleOrder saleOrder = saleOrderLine.getSaleOrder();
            ArrayList<SaleOrderLine> saleOrderLineList = new ArrayList<SaleOrderLine>();
            saleOrderLineList.add(saleOrderLine);
            try {
                this.saleOrderInvoiceService.generateSubscriptionInvoice(lateSubscriptionsList, saleOrder);
                ++i;
                this.incrementDone();
            }
            catch (Exception e) {
                this.incrementAnomaly();
                this.comment = this.comment + e.getMessage();
                TraceBackService.trace((Exception)new Exception(e), (String)"invoice", (long)this.batch.getId());
            }
            finally {
                if (i % 10 != 0) continue;
                JPA.clear();
            }
        }
    }

    protected void stop() {
        this.comment = this.comment + String.format("\t* %s abonnement(s) factur\u00e9(s) \n", this.batch.getDone());
        this.comment = this.comment + String.format(I18n.get((String)"\t* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(this.comment);
    }
}

