/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.invoice.generator;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public abstract class InvoiceGeneratorSupplyChain
extends InvoiceGenerator {
    @Inject
    protected GeneralService generalService;
    protected SaleOrder saleOrder;
    protected PurchaseOrder purchaseOrder;

    protected InvoiceGeneratorSupplyChain(SaleOrder saleOrder) throws AxelorException {
        super(3, saleOrder.getCompany(), saleOrder.getPaymentCondition(), saleOrder.getPaymentMode(), saleOrder.getMainInvoicingAddress(), saleOrder.getClientPartner(), saleOrder.getContactPartner(), saleOrder.getCurrency(), saleOrder.getPriceList(), saleOrder.getSaleOrderSeq(), saleOrder.getExternalReference(), saleOrder.getInAti(), saleOrder.getCompanyBankDetails());
        this.saleOrder = saleOrder;
    }

    protected InvoiceGeneratorSupplyChain(PurchaseOrder purchaseOrder) throws AxelorException {
        super(1, purchaseOrder.getCompany(), purchaseOrder.getPaymentCondition(), purchaseOrder.getPaymentMode(), null, purchaseOrder.getSupplierPartner(), purchaseOrder.getContactPartner(), purchaseOrder.getCurrency(), purchaseOrder.getPriceList(), purchaseOrder.getPurchaseOrderSeq(), purchaseOrder.getExternalReference(), purchaseOrder.getInAti(), purchaseOrder.getCompanyBankDetails());
        this.purchaseOrder = purchaseOrder;
    }

    protected InvoiceGeneratorSupplyChain(StockMove stockMove, int invoiceOperationType) throws AxelorException {
        super(invoiceOperationType, stockMove.getCompany(), stockMove.getPartner(), null, null, stockMove.getStockMoveSeq(), stockMove.getTrackingNumber(), null);
    }

    protected Invoice createInvoiceHeader() throws AxelorException {
        Invoice invoice = super.createInvoiceHeader();
        if (!((GeneralService)Beans.get(GeneralService.class)).getGeneral().getManageInvoicedAmountByLine().booleanValue()) {
            if (this.saleOrder != null) {
                invoice.setSaleOrder(this.saleOrder);
            } else {
                invoice.setPurchaseOrder(this.purchaseOrder);
            }
        }
        return invoice;
    }
}

