/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.invoice.generator;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.AnalyticDistributionLineRepository;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public abstract class InvoiceLineGeneratorSupplyChain
extends InvoiceLineGenerator {
    @Inject
    protected InvoiceLineService invoiceLineService;
    @Inject
    protected UnitConversionService unitConversionService;
    protected SaleOrderLine saleOrderLine;
    protected PurchaseOrderLine purchaseOrderLine;
    protected StockMoveLine stockMoveLine;
    protected Subscription subscription;

    protected InvoiceLineGeneratorSupplyChain(Invoice invoice, Product product, String productName, String description, BigDecimal qty, Unit unit, int sequence, boolean isTaxInvoice, SaleOrderLine saleOrderLine, PurchaseOrderLine purchaseOrderLine, StockMoveLine stockMoveLine) throws AxelorException {
        super(invoice, product, productName, description, qty, unit, sequence, isTaxInvoice);
        this.saleOrderLine = saleOrderLine;
        this.purchaseOrderLine = purchaseOrderLine;
        this.stockMoveLine = stockMoveLine;
        if (saleOrderLine != null) {
            this.discountAmount = saleOrderLine.getDiscountAmount();
            this.price = saleOrderLine.getPrice();
            this.priceDiscounted = saleOrderLine.getPriceDiscounted();
            this.taxLine = saleOrderLine.getTaxLine();
            this.discountTypeSelect = saleOrderLine.getDiscountTypeSelect();
            this.isTitleLine = saleOrderLine.getIsTitleLine();
        } else if (purchaseOrderLine != null) {
            this.isTitleLine = purchaseOrderLine.getIsTitleLine();
            this.purchaseOrderLine = purchaseOrderLine;
            this.discountAmount = purchaseOrderLine.getDiscountAmount();
            this.price = purchaseOrderLine.getPrice();
            this.priceDiscounted = purchaseOrderLine.getPriceDiscounted();
            this.taxLine = purchaseOrderLine.getTaxLine();
            this.discountTypeSelect = purchaseOrderLine.getDiscountTypeSelect();
        } else if (stockMoveLine != null) {
            this.priceDiscounted = stockMoveLine.getUnitPriceUntaxed();
            Unit saleOrPurchaseUnit = this.getSaleOrPurchaseUnit();
            if (saleOrPurchaseUnit != null && this.unit != null && !this.unit.equals((Object)saleOrPurchaseUnit)) {
                this.qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convertWithProduct(this.unit, saleOrPurchaseUnit, qty, stockMoveLine.getProduct());
                this.priceDiscounted = ((UnitConversionService)Beans.get(UnitConversionService.class)).convertWithProduct(this.unit, saleOrPurchaseUnit, this.priceDiscounted, product);
                this.unit = saleOrPurchaseUnit;
            }
        }
    }

    protected InvoiceLineGeneratorSupplyChain(Invoice invoice, Product product, String productName, String description, BigDecimal qty, Unit unit, int sequence, boolean isTaxInvoice, SaleOrderLine saleOrderLine, PurchaseOrderLine purchaseOrderLine, StockMoveLine stockMoveLine, Subscription subscription) throws AxelorException {
        this(invoice, product, productName, description, qty, unit, sequence, isTaxInvoice, saleOrderLine, purchaseOrderLine, stockMoveLine);
        this.subscription = subscription;
    }

    protected InvoiceLine createInvoiceLine() throws AxelorException {
        InvoiceLine invoiceLine = super.createInvoiceLine();
        if (this.saleOrderLine != null && this.product != null && "subscriptable".equals(this.product.getProductTypeSelect()) && this.saleOrderLine.getSubscriptionList() != null && !this.saleOrderLine.getSubscriptionList().isEmpty()) {
            BigDecimal subscriptionListSize = new BigDecimal(this.saleOrderLine.getSubscriptionList().size());
            this.exTaxTotal = this.exTaxTotal.divide(subscriptionListSize, 2, RoundingMode.HALF_EVEN);
            this.inTaxTotal = this.inTaxTotal.divide(subscriptionListSize, 2, RoundingMode.HALF_EVEN);
        }
        this.assignOriginElements(invoiceLine);
        if (this.saleOrderLine != null) {
            this.copyAnalyticDistributionLines(this.saleOrderLine.getAnalyticDistributionLineList(), invoiceLine);
        } else if (this.purchaseOrderLine != null) {
            this.copyAnalyticDistributionLines(this.purchaseOrderLine.getAnalyticDistributionLineList(), invoiceLine);
            this.copyBudgetDistributionList(this.purchaseOrderLine.getBudgetDistributionList(), invoiceLine);
            invoiceLine.setBudget(this.purchaseOrderLine.getBudget());
        } else if (this.stockMoveLine != null) {
            this.price = this.invoiceLineService.getUnitPrice(this.invoice, invoiceLine, this.taxLine, InvoiceToolService.isPurchase((Invoice)this.invoice));
            this.price = ((UnitConversionService)Beans.get(UnitConversionService.class)).convertWithProduct(this.stockMoveLine.getUnit(), this.unit, this.price, this.product);
        }
        return invoiceLine;
    }

    public void assignOriginElements(InvoiceLine invoiceLine) throws AxelorException {
        if (!((GeneralService)Beans.get(GeneralService.class)).getGeneral().getManageInvoicedAmountByLine().booleanValue()) {
            return;
        }
        StockMove stockMove = null;
        if (this.stockMoveLine != null) {
            stockMove = this.stockMoveLine.getStockMove();
        }
        if (stockMove != null) {
            if (InvoiceToolService.isPurchase((Invoice)this.invoice)) {
                invoiceLine.setIncomingStockMove(stockMove);
            } else {
                invoiceLine.setOutgoingStockMove(stockMove);
            }
        }
        if (this.saleOrderLine != null) {
            invoiceLine.setSaleOrderLine(this.saleOrderLine);
        }
        if (this.purchaseOrderLine != null) {
            invoiceLine.setPurchaseOrderLine(this.purchaseOrderLine);
        }
    }

    public void copyAnalyticDistributionLines(List<AnalyticDistributionLine> originalAnalyticDistributionLineList, InvoiceLine invoiceLine) {
        if (originalAnalyticDistributionLineList == null) {
            return;
        }
        for (AnalyticDistributionLine analyticDistributionLineIt : originalAnalyticDistributionLineList) {
            invoiceLine.addAnalyticDistributionLineListItem((AnalyticDistributionLine)((AnalyticDistributionLineRepository)((Object)Beans.get(AnalyticDistributionLineRepository.class))).copy((Model)analyticDistributionLineIt, false));
        }
    }

    public void copyBudgetDistributionList(List<BudgetDistribution> originalBudgetDistributionList, InvoiceLine invoiceLine) {
        if (originalBudgetDistributionList == null) {
            return;
        }
        for (BudgetDistribution budgetDistributionIt : originalBudgetDistributionList) {
            BudgetDistribution budgetDistribution = new BudgetDistribution();
            budgetDistribution.setBudget(budgetDistributionIt.getBudget());
            budgetDistribution.setAmount(budgetDistributionIt.getAmount());
            invoiceLine.addBudgetDistributionListItem(budgetDistribution);
        }
    }

    public Unit getSaleOrPurchaseUnit() throws AxelorException {
        if (!InvoiceToolService.isPurchase((Invoice)this.invoice)) {
            return this.product.getSalesUnit();
        }
        return this.product.getPurchasesUnit();
    }
}

