/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.workflow;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.workflow.ventilate.VentilateState;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VentilateStateSupplyChain
extends VentilateState {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private SaleOrderInvoiceService saleOrderInvoiceService;
    @Inject
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;
    @Inject
    protected SaleOrderRepository saleOrderRepository;
    @Inject
    protected PurchaseOrderRepository purchaseOrderRepository;

    public void process() throws AxelorException {
        super.process();
        if (InvoiceToolService.isPurchase((Invoice)this.invoice)) {
            this.purchaseOrderProcess();
        } else {
            this.saleOrderProcess();
        }
    }

    public void saleOrderProcess() throws AxelorException {
        SaleOrder invoiceSaleOrder = this.invoice.getSaleOrder();
        if (invoiceSaleOrder != null) {
            this.log.debug("Update the invoiced amount of the sale order : {}", (Object)invoiceSaleOrder.getSaleOrderSeq());
            invoiceSaleOrder.setAmountInvoiced(this.saleOrderInvoiceService.getInvoicedAmount(invoiceSaleOrder, this.invoice.getId(), false));
        } else {
            ArrayList saleOrderList = Lists.newArrayList();
            for (InvoiceLine invoiceLine : this.invoice.getInvoiceLineList()) {
                SaleOrder saleOrder = this.saleOrderLineProcess(invoiceLine);
                if (saleOrder == null || saleOrderList.contains((Object)saleOrder)) continue;
                saleOrderList.add(saleOrder);
            }
            for (SaleOrder saleOrder : saleOrderList) {
                this.log.debug("Update the invoiced amount of the sale order : {}", (Object)saleOrder.getSaleOrderSeq());
                saleOrder.setAmountInvoiced(this.saleOrderInvoiceService.getInvoicedAmount(saleOrder, this.invoice.getId(), false));
                this.saleOrderRepository.save((Model)saleOrder);
            }
        }
    }

    public SaleOrder saleOrderLineProcess(InvoiceLine invoiceLine) throws AxelorException {
        SaleOrderLine saleOrderLine = invoiceLine.getSaleOrderLine();
        if (saleOrderLine == null) {
            return null;
        }
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        BigDecimal invoicedAmountToAdd = invoiceLine.getExTaxTotal();
        if (InvoiceToolService.isRefund((Invoice)invoiceLine.getInvoice())) {
            invoicedAmountToAdd = invoicedAmountToAdd.negate();
        }
        if (!this.invoice.getCurrency().equals((Object)saleOrder.getCurrency()) && saleOrderLine.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currentCompanyInvoicedAmount = invoiceLine.getCompanyExTaxTotal();
            BigDecimal rate = currentCompanyInvoicedAmount.divide(saleOrderLine.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmountToAdd = rate.multiply(saleOrderLine.getExTaxTotal());
        }
        saleOrderLine.setAmountInvoiced(saleOrderLine.getAmountInvoiced().add(invoicedAmountToAdd));
        return saleOrder;
    }

    public void purchaseOrderProcess() throws AxelorException {
        PurchaseOrder invoicePurchaseOrder = this.invoice.getPurchaseOrder();
        if (invoicePurchaseOrder != null) {
            this.log.debug("Update the invoiced amount of the purchase order : {}", (Object)invoicePurchaseOrder.getPurchaseOrderSeq());
            invoicePurchaseOrder.setAmountInvoiced(this.purchaseOrderInvoiceService.getInvoicedAmount(invoicePurchaseOrder, this.invoice.getId(), false));
        } else {
            ArrayList purchaseOrderList = Lists.newArrayList();
            for (InvoiceLine invoiceLine : this.invoice.getInvoiceLineList()) {
                PurchaseOrder purchaseOrder = this.purchaseOrderLineProcess(invoiceLine);
                if (purchaseOrder == null || purchaseOrderList.contains((Object)purchaseOrder)) continue;
                purchaseOrderList.add(purchaseOrder);
            }
            for (PurchaseOrder purchaseOrder : purchaseOrderList) {
                this.log.debug("Update the invoiced amount of the purchase order : {}", (Object)purchaseOrder.getPurchaseOrderSeq());
                purchaseOrder.setAmountInvoiced(this.purchaseOrderInvoiceService.getInvoicedAmount(purchaseOrder, this.invoice.getId(), false));
                this.purchaseOrderRepository.save((Model)purchaseOrder);
            }
        }
    }

    public PurchaseOrder purchaseOrderLineProcess(InvoiceLine invoiceLine) throws AxelorException {
        PurchaseOrderLine purchaseOrderLine = invoiceLine.getPurchaseOrderLine();
        if (purchaseOrderLine == null) {
            return null;
        }
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        BigDecimal invoicedAmountToAdd = invoiceLine.getExTaxTotal();
        if (InvoiceToolService.isRefund((Invoice)invoiceLine.getInvoice())) {
            invoicedAmountToAdd = invoicedAmountToAdd.negate();
        }
        if (!this.invoice.getCurrency().equals((Object)purchaseOrder.getCurrency()) && purchaseOrderLine.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currentCompanyInvoicedAmount = invoiceLine.getCompanyExTaxTotal();
            BigDecimal rate = currentCompanyInvoicedAmount.divide(purchaseOrderLine.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmountToAdd = rate.multiply(purchaseOrderLine.getExTaxTotal());
        }
        purchaseOrderLine.setAmountInvoiced(purchaseOrderLine.getAmountInvoiced().add(invoicedAmountToAdd));
        return purchaseOrder;
    }
}

