/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.db.CustomerCreditLine;
import com.axelor.apps.supplychain.service.CustomerCreditLineService;
import com.axelor.exception.AxelorException;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import java.util.Map;

public class CustomerCreditLineController {
    @Inject
    protected CustomerCreditLineService customerCreditLineService;
    @Inject
    protected PartnerRepository partnerRepo;

    public void computeUsedCredit(ActionRequest request, ActionResponse response) {
        CustomerCreditLine customerCreditLine = (CustomerCreditLine)((Object)request.getContext().asType(CustomerCreditLine.class));
        customerCreditLine = this.customerCreditLineService.computeUsedCredit(customerCreditLine);
        response.setValues((Object)customerCreditLine);
    }

    public void generateLines(ActionRequest request, ActionResponse response) throws AxelorException {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        partner.setCustomerCreditLineList(this.customerCreditLineService.generateLines(partner).getCustomerCreditLineList());
        response.setValues((Object)partner);
    }

    public void updateLinesFromPartner(ActionRequest request, ActionResponse response) throws AxelorException {
        Partner partnerView = (Partner)((Object)request.getContext().asType(Partner.class));
        if (partnerView.getId() != null && partnerView.getId() > 0L) {
            Partner partner = (Partner)this.partnerRepo.find(partnerView.getId());
            this.customerCreditLineService.updateLines(partner);
            response.setValue("customerCreditLineList", partner.getCustomerCreditLineList());
        }
    }

    public void updateLinesFromSaleOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        if (saleOrder.getClientPartner() != null) {
            Partner partner = saleOrder.getClientPartner();
            Map<String, Object> map = this.customerCreditLineService.updateLinesFromOrder((Partner)this.partnerRepo.find(partner.getId()), saleOrder);
            response.setValues(map);
        }
    }
}

