/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InvoiceController {
    @Inject
    protected GeneralService generalService;
    @Inject
    protected SaleOrderInvoiceService saleOrderInvoiceService;

    public void fillInLines(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        this.saleOrderInvoiceService.fillInLines(invoice);
        response.setValues((Object)invoice);
    }

    public void mergeInvoice(ActionRequest request, ActionResponse response) {
        ArrayList<Invoice> invoiceList = new ArrayList<Invoice>();
        ArrayList<Long> invoiceIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        if (request.getContext().get((Object)"invoiceToMerge") != null) {
            if (request.getContext().get((Object)"invoiceToMerge") instanceof List) {
                List invoiceMap = (List)request.getContext().get((Object)"invoiceToMerge");
                for (Map map : invoiceMap) {
                    invoiceIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String invoiceIdListStr = (String)request.getContext().get((Object)"invoiceToMerge");
                for (String invoiceId : invoiceIdListStr.split(",")) {
                    invoiceIdList.add(new Long(invoiceId));
                }
                fromPopup = true;
            }
        }
        Company commonCompany = null;
        Currency commonCurrency = null;
        Partner commonPartner = null;
        PaymentCondition commonPaymentCondition = null;
        boolean existPaymentConditionDiff = false;
        Partner commonContactPartner = null;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        PaymentMode commonPaymentMode = null;
        boolean existPaymentModeDiff = false;
        SaleOrder commonSaleOrder = null;
        boolean saleOrderIsNull = false;
        int count = 1;
        for (Long invoiceId : invoiceIdList) {
            Invoice invoiceTemp = (Invoice)((Object)JPA.em().find(Invoice.class, (Object)invoiceId));
            invoiceList.add(invoiceTemp);
            if (count == 1) {
                commonCompany = invoiceTemp.getCompany();
                commonCurrency = invoiceTemp.getCurrency();
                commonPartner = invoiceTemp.getPartner();
                commonPaymentCondition = invoiceTemp.getPaymentCondition();
                commonContactPartner = invoiceTemp.getContactPartner();
                commonPriceList = invoiceTemp.getPriceList();
                commonPaymentMode = invoiceTemp.getPaymentMode();
                commonSaleOrder = invoiceTemp.getSaleOrder();
                if (commonSaleOrder == null) {
                    saleOrderIsNull = true;
                }
            } else {
                if (commonCompany != null && !commonCompany.equals((Object)invoiceTemp.getCompany())) {
                    commonCompany = null;
                }
                if (commonCurrency != null && !commonCurrency.equals((Object)invoiceTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonPartner != null && !commonPartner.equals((Object)invoiceTemp.getPartner())) {
                    commonPartner = null;
                }
                if (commonPaymentCondition != null && !commonPaymentCondition.equals((Object)invoiceTemp.getPaymentCondition())) {
                    commonPaymentCondition = null;
                    existPaymentConditionDiff = true;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)invoiceTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)invoiceTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
                if (commonPaymentMode != null && !commonPaymentMode.equals((Object)invoiceTemp.getPaymentMode())) {
                    commonPaymentMode = null;
                    existPaymentModeDiff = true;
                }
                if (commonSaleOrder != null && !commonSaleOrder.equals((Object)invoiceTemp.getSaleOrder())) {
                    commonSaleOrder = null;
                }
                if (invoiceTemp.getSaleOrder() != null) {
                    saleOrderIsNull = false;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all invoices"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all invoices"));
        }
        if (commonPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The partner is required and must be the same for all invoices"));
        }
        if (commonSaleOrder == null && !this.generalService.getGeneral().getManageInvoicedAmountByLine().booleanValue() && !saleOrderIsNull) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The sale order must be the same for all invoices"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"paymentMode") != null) {
            commonPaymentMode = (PaymentMode)((Object)JPA.em().find(PaymentMode.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"paymentMode")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"paymentCondition") != null) {
            commonPaymentCondition = (PaymentCondition)JPA.em().find(PaymentCondition.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"paymentCondition")).get("id")).intValue()));
        }
        if (!fromPopup && (existPaymentConditionDiff || existContactPartnerDiff || existPriceListDiff || existPaymentModeDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge invoice").model(Wizard.class.getName()).add("form", "customer-invoices-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonPartner.getId().toString());
            }
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existPaymentModeDiff) {
                confirmView.context("contextPaymentModeToCheck", (Object)"true");
            }
            if (existPaymentConditionDiff) {
                confirmView.context("contextPaymentConditionToCheck", (Object)"true");
            }
            confirmView.context("invoiceToMerge", (Object)Joiner.on((String)",").join(invoiceIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            Invoice invoice = this.saleOrderInvoiceService.mergeInvoice(invoiceList, commonCompany, commonCurrency, commonPartner, commonContactPartner, commonPriceList, commonPaymentMode, commonPaymentCondition, commonSaleOrder);
            if (invoice != null) {
                response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (AxelorException ae) {
            response.setFlash(ae.getLocalizedMessage());
        }
    }
}

