/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.TimetableService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PurchaseOrderController {
    @Inject
    private PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychain;
    @Inject
    protected GeneralService generalService;
    @Inject
    protected PurchaseOrderRepository purchaseOrderRepo;

    public void createStockMove(ActionRequest request, ActionResponse response) throws AxelorException {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        if (purchaseOrder.getId() != null) {
            if (this.purchaseOrderServiceSupplychain.existActiveStockMoveForPurchaseOrder(purchaseOrder.getId())) {
                if (!this.generalService.getGeneral().getSupplierStockMoveGenerationAuto().booleanValue()) {
                    response.setFlash(I18n.get((String)"An active stockMove already exists for this purchaseOrder"));
                }
            } else {
                Long stockMoveId = this.purchaseOrderServiceSupplychain.createStocksMove((PurchaseOrder)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
                if (!this.generalService.getGeneral().getSupplierStockMoveGenerationAuto().booleanValue()) {
                    response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(stockMoveId)).map());
                }
            }
        }
    }

    public void getLocation(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        if (purchaseOrder.getCompany() != null) {
            response.setValue("location", (Object)this.purchaseOrderServiceSupplychain.getLocation(purchaseOrder.getCompany()));
        }
    }

    public void clearPurchaseOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        purchaseOrder = (PurchaseOrder)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId());
        this.purchaseOrderServiceSupplychain.clearPurchaseOrder(purchaseOrder);
    }

    public void updateTimetable(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        if (purchaseOrder.getId() != null && purchaseOrder.getId() > 0L) {
            purchaseOrder = (PurchaseOrder)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId());
        }
        ((TimetableService)Beans.get(TimetableService.class)).updateTimetable(purchaseOrder);
        response.setValues((Object)purchaseOrder);
    }

    public void generateBudgetDistribution(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        if (this.generalService.getGeneral().getManageBudget().booleanValue() && !this.generalService.getGeneral().getManageMultiBudget().booleanValue()) {
            purchaseOrder = (PurchaseOrder)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId());
            this.purchaseOrderServiceSupplychain.generateBudgetDistribution(purchaseOrder);
            response.setValues((Object)purchaseOrder);
        }
    }

    public void mergePurchaseOrder(ActionRequest request, ActionResponse response) {
        ArrayList<PurchaseOrder> purchaseOrderList = new ArrayList<PurchaseOrder>();
        ArrayList<Long> purchaseOrderIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        if (request.getContext().get((Object)"purchaseOrderToMerge") != null) {
            if (request.getContext().get((Object)"purchaseOrderToMerge") instanceof List) {
                List purchaseOrderMap = (List)request.getContext().get((Object)"purchaseOrderToMerge");
                for (Map map : purchaseOrderMap) {
                    purchaseOrderIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String purchaseOrderIdListStr = (String)request.getContext().get((Object)"purchaseOrderToMerge");
                for (String purchaseOrderId : purchaseOrderIdListStr.split(",")) {
                    purchaseOrderIdList.add(new Long(purchaseOrderId));
                }
                fromPopup = true;
            }
        }
        Currency commonCurrency = null;
        Partner commonSupplierPartner = null;
        Company commonCompany = null;
        Partner commonContactPartner = null;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        Location commonLocation = null;
        boolean existLocationDiff = false;
        int count = 1;
        for (Long purchaseOrderId : purchaseOrderIdList) {
            PurchaseOrder purchaseOrderTemp = (PurchaseOrder)((Object)JPA.em().find(PurchaseOrder.class, (Object)purchaseOrderId));
            purchaseOrderList.add(purchaseOrderTemp);
            if (count == 1) {
                commonCurrency = purchaseOrderTemp.getCurrency();
                commonSupplierPartner = purchaseOrderTemp.getSupplierPartner();
                commonCompany = purchaseOrderTemp.getCompany();
                commonContactPartner = purchaseOrderTemp.getContactPartner();
                commonPriceList = purchaseOrderTemp.getPriceList();
                commonLocation = purchaseOrderTemp.getLocation();
            } else {
                if (commonCurrency != null && !commonCurrency.equals((Object)purchaseOrderTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonSupplierPartner != null && !commonSupplierPartner.equals((Object)purchaseOrderTemp.getSupplierPartner())) {
                    commonSupplierPartner = null;
                }
                if (commonCompany != null && !commonCompany.equals((Object)purchaseOrderTemp.getCompany())) {
                    commonCompany = null;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)purchaseOrderTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)purchaseOrderTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
                if (commonLocation != null && !commonLocation.equals((Object)purchaseOrderTemp.getLocation())) {
                    commonLocation = null;
                    existLocationDiff = true;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all purchase orders"));
        }
        if (commonSupplierPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The supplier Partner is required and must be the same for all purchase orders"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all purchase orders"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"location") != null) {
            commonLocation = (Location)JPA.em().find(Location.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"location")).get("id")).intValue()));
        }
        if (!fromPopup && (existContactPartnerDiff || existPriceListDiff || existLocationDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge purchase order").model(Wizard.class.getName()).add("form", "purchase-order-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonSupplierPartner.getId().toString());
            }
            if (existLocationDiff) {
                confirmView.context("contextLocationToCheck", (Object)"true");
            }
            confirmView.context("purchaseOrderToMerge", (Object)Joiner.on((String)",").join(purchaseOrderIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            PurchaseOrder purchaseOrder = this.purchaseOrderServiceSupplychain.mergePurchaseOrders(purchaseOrderList, commonCurrency, commonSupplierPartner, commonCompany, commonLocation, commonContactPartner, commonPriceList);
            if (purchaseOrder != null) {
                response.setView(ActionView.define((String)"Purchase Order").model(PurchaseOrder.class.getName()).add("grid", "purchase-order-grid").add("form", "purchase-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(purchaseOrder.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (AxelorException ae) {
            response.setFlash(ae.getLocalizedMessage());
        }
    }

    public void updatePurchaseOrderOnCancel(ActionRequest request, ActionResponse response) throws AxelorException {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        PurchaseOrder purchaseOrder = (PurchaseOrder)this.purchaseOrderRepo.find(stockMove.getPurchaseOrder().getId());
        this.purchaseOrderServiceSupplychain.updatePurchaseOrderOnCancel(stockMove, purchaseOrder);
    }
}

