/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;

public class PurchaseOrderInvoiceController {
    @Inject
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;

    public void generateInvoice(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        purchaseOrder = (PurchaseOrder)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId());
        try {
            Invoice invoice = this.purchaseOrderInvoiceService.generateInvoice(purchaseOrder);
            if (invoice != null) {
                response.setReload(true);
                response.setView(ActionView.define((String)I18n.get((String)"Invoice created")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").domain("self.purchaseOrder.id = " + String.valueOf(invoice.getId())).context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
    }
}

