/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.apps.supplychain.db.repo.SubscriptionRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceServiceImpl;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.TimetableService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SaleOrderController {
    @Inject
    private SaleOrderRepository saleOrderRepo;
    @Inject
    protected GeneralService generalService;
    @Inject
    private SaleOrderInvoiceServiceImpl saleOrderInvoiceServiceImpl;
    @Inject
    private StockMoveRepository stockMoveRepo;

    public void createStockMove(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        if (saleOrder.getId() != null) {
            SaleOrderStockService saleOrderStockService = (SaleOrderStockService)Beans.get(SaleOrderStockService.class);
            StockMove stockMove = saleOrderStockService.createStocksMovesFromSaleOrder((SaleOrder)this.saleOrderRepo.find(saleOrder.getId()));
            if (stockMove != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Stock Move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(stockMove.getId())).map());
            } else {
                response.setFlash(I18n.get((String)"No delivery stock move to generate for this sale order"));
            }
        }
    }

    public void getLocation(ActionRequest request, ActionResponse response) {
        Location location;
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        if (saleOrder != null && (location = ((SaleOrderStockService)Beans.get(SaleOrderStockService.class)).getLocation(saleOrder.getCompany())) != null) {
            response.setValue("location", (Object)location);
        }
    }

    public void generatePurchaseOrdersFromSelectedSOLines(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        if (saleOrder.getId() != null) {
            if (request.getContext().get((Object)"supplierPartnerSelect") != null) {
                Partner partner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"supplierPartnerSelect")).get("id")).intValue())));
                ArrayList<Long> saleOrderLineIdSelected = new ArrayList<Long>();
                String saleOrderLineIdSelectedStr = (String)request.getContext().get((Object)"saleOrderLineIdSelected");
                for (String saleOrderId : saleOrderLineIdSelectedStr.split(",")) {
                    saleOrderLineIdSelected.add(new Long(saleOrderId));
                }
                List saleOrderLinesSelected = JPA.all(SaleOrderLine.class).filter("self.id IN (:saleOderLineIdList)").bind("saleOderLineIdList", saleOrderLineIdSelected).fetch();
                PurchaseOrder purchaseOrder = ((SaleOrderPurchaseService)Beans.get(SaleOrderPurchaseService.class)).createPurchaseOrder(partner, saleOrderLinesSelected, (SaleOrder)this.saleOrderRepo.find(saleOrder.getId()));
                response.setView(ActionView.define((String)I18n.get((String)"Purchase Order")).model(PurchaseOrder.class.getName()).add("form", "purchase-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(purchaseOrder.getId())).map());
                response.setCanClose(true);
            } else {
                Partner supplierPartner = null;
                ArrayList<Long> saleOrderLineIdSelected = new ArrayList<Long>();
                for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                    if (!saleOrderLine.isSelected()) continue;
                    if (supplierPartner == null) {
                        supplierPartner = saleOrderLine.getSupplierPartner();
                    } else if (!supplierPartner.equals((Object)saleOrderLine.getSupplierPartner())) {
                        supplierPartner = null;
                        break;
                    }
                    saleOrderLineIdSelected.add(saleOrderLine.getId());
                }
                if (saleOrderLineIdSelected.isEmpty()) {
                    response.setFlash(I18n.get((String)"At least one sale order line must be selected"));
                } else {
                    response.setView(ActionView.define((String)"SaleOrder").model(SaleOrder.class.getName()).add("form", "sale-order-generate-po-select-supplierpartner-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(saleOrder.getId())).context("supplierPartnerId", (Object)(supplierPartner != null ? String.valueOf(supplierPartner.getId()) : "NULL")).context("saleOrderLineIdSelected", (Object)Joiner.on((String)",").join(saleOrderLineIdSelected)).map());
                }
            }
        }
    }

    public void generateInvoice(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        try {
            saleOrder = (SaleOrder)this.saleOrderRepo.find(saleOrder.getId());
            ArrayList<Long> saleOrderLineIdSelected = new ArrayList<Long>();
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                if (!saleOrderLine.isSelected()) continue;
                saleOrderLineIdSelected.add(saleOrderLine.getId());
            }
            Invoice invoice = null;
            if (!saleOrderLineIdSelected.isEmpty()) {
                List saleOrderLinesSelected = JPA.all(SaleOrderLine.class).filter("self.id IN (:saleOderLineIdList)").bind("saleOderLineIdList", saleOrderLineIdSelected).fetch();
                invoice = this.saleOrderInvoiceServiceImpl.generateInvoice(saleOrder, saleOrderLinesSelected);
            } else {
                invoice = this.saleOrderInvoiceServiceImpl.generateInvoice(saleOrder);
            }
            if (invoice != null) {
                response.setReload(true);
                response.setFlash(I18n.get((String)"Invoice created"));
                response.setView(ActionView.define((String)I18n.get((String)"Invoice generated")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
    }

    public void generateInvoiceFromPopup(ActionRequest request, ActionResponse response) {
        String saleOrderId = request.getContext().get((Object)"_id").toString();
        try {
            SaleOrder saleOrder = (SaleOrder)this.saleOrderRepo.find(Long.valueOf(saleOrderId));
            ArrayList<Long> saleOrderLineIdSelected = new ArrayList<Long>();
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                if (!saleOrderLine.isSelected()) continue;
                saleOrderLineIdSelected.add(saleOrderLine.getId());
            }
            Invoice invoice = null;
            if (!saleOrderLineIdSelected.isEmpty()) {
                List saleOrderLinesSelected = JPA.all(SaleOrderLine.class).filter("self.id IN (:saleOderLineIdList)").bind("saleOderLineIdList", saleOrderLineIdSelected).fetch();
                invoice = this.saleOrderInvoiceServiceImpl.generateInvoice(saleOrder, saleOrderLinesSelected);
            } else {
                invoice = this.saleOrderInvoiceServiceImpl.generateInvoice(saleOrder);
            }
            if (invoice != null) {
                response.setCanClose(true);
                response.setFlash(I18n.get((String)"Invoice created"));
                response.setView(ActionView.define((String)I18n.get((String)"Invoice generated")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
    }

    public void getSubscriptionSaleOrdersToInvoice(ActionRequest request, ActionResponse response) throws AxelorException {
        List subscriptionList = ((SubscriptionRepository)((Object)Beans.get(SubscriptionRepository.class))).all().filter("self.invoiced = false AND self.invoicingDate <= ?1", new Object[]{this.generalService.getTodayDate()}).fetch();
        ArrayList<Long> listId = new ArrayList<Long>();
        for (Subscription subscription : subscriptionList) {
            listId.add(subscription.getSaleOrderLine().getSaleOrder().getId());
        }
        if (listId.isEmpty()) {
            throw new AxelorException(I18n.get((String)"No Subscription to Invoice"), 4, new Object[0]);
        }
        if (listId.size() == 1) {
            response.setView(ActionView.define((String)I18n.get((String)"Subscription Sale Orders")).model(SaleOrder.class.getName()).add("grid", "sale-order-subscription-grid").add("form", "sale-order-form").domain("self.id = " + listId.get(0)).map());
        }
        response.setView(ActionView.define((String)I18n.get((String)"Subscription Sale Orders")).model(SaleOrder.class.getName()).add("grid", "sale-order-subscription-grid").add("form", "sale-order-form").domain("self.id in (" + Joiner.on((String)",").join(listId) + ")").map());
    }

    public void invoiceSubscriptions(ActionRequest request, ActionResponse response) throws AxelorException {
        List listSelectedSaleOrder = (List)request.getContext().get((Object)"_ids");
        if (listSelectedSaleOrder != null) {
            SaleOrder saleOrder = null;
            ArrayList<Long> listInvoiceId = new ArrayList<Long>();
            for (Integer integer : listSelectedSaleOrder) {
                saleOrder = (SaleOrder)this.saleOrderRepo.find(integer.longValue());
                Invoice invoice = this.saleOrderInvoiceServiceImpl.generateSubcriptionInvoiceForSaleOrder(saleOrder);
                if (invoice == null) continue;
                listInvoiceId.add(invoice.getId());
            }
            if (listInvoiceId.isEmpty()) {
                throw new AxelorException(I18n.get((String)"No sale order selected or no subscription to invoice"), 4, new Object[0]);
            }
            response.setReload(true);
            if (listInvoiceId.size() == 1) {
                response.setView(ActionView.define((String)I18n.get((String)"Invoice Generated")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain("self.id = " + listInvoiceId.get(0)).map());
            }
            response.setView(ActionView.define((String)I18n.get((String)"Invoices Generated")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain("self.id in (" + Joiner.on((String)",").join(listInvoiceId) + ")").map());
        }
    }

    public void invoiceSubscriptionsSaleOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        Invoice invoice = this.saleOrderInvoiceServiceImpl.generateSubcriptionInvoiceForSaleOrder(saleOrder = (SaleOrder)this.saleOrderRepo.find(saleOrder.getId()));
        if (invoice == null) {
            throw new AxelorException(I18n.get((String)"No Subscription to Invoice"), 4, new Object[0]);
        }
        response.setReload(true);
        response.setView(ActionView.define((String)I18n.get((String)"Invoice Generated")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
    }

    public void updateTimetable(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        if (saleOrder.getId() != null && saleOrder.getId() > 0L) {
            saleOrder = (SaleOrder)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId());
        }
        ((TimetableService)Beans.get(TimetableService.class)).updateTimetable(saleOrder);
        response.setValues((Object)saleOrder);
    }

    @Transactional
    public void updateSaleOrderOnCancel(ActionRequest request, ActionResponse response) throws AxelorException {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        SaleOrder so = (SaleOrder)this.saleOrderRepo.find(stockMove.getSaleOrder().getId());
        List stockMoveList = Lists.newArrayList();
        stockMoveList = this.stockMoveRepo.all().filter("self.saleOrder = ?1", new Object[]{so}).fetch();
        so.setDeliveryState(SaleOrderRepository.STATE_NOT_DELIVERED);
        for (StockMove stock : stockMoveList) {
            if (stock.getStatusSelect() == 4 || stock.getId().equals(stockMove.getId())) continue;
            so.setDeliveryState(SaleOrderRepository.STATE_PARTIALLY_DELIVERED);
            break;
        }
        if (so.getStatusSelect() == 4 && this.generalService.getGeneral().getTerminateSaleOrderOnDelivery().booleanValue()) {
            so.setStatusSelect(3);
        }
        this.saleOrderRepo.save((Model)so);
    }
}

