/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChainImpl;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;

public class SaleOrderLineController {
    @Inject
    protected SaleOrderLineServiceSupplyChainImpl saleOrderLineServiceSupplyChainImpl;

    public void computeAnalyticDistribution(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        if (saleOrder == null) {
            saleOrder = (SaleOrder)((Object)request.getContext().getParentContext().asType(SaleOrder.class));
            saleOrderLine.setSaleOrder(saleOrder);
        }
        if (((GeneralService)Beans.get(GeneralService.class)).getGeneral().getManageAnalyticAccounting().booleanValue()) {
            saleOrderLine = this.saleOrderLineServiceSupplyChainImpl.computeAnalyticDistribution(saleOrderLine);
            response.setValue("analyticDistributionLineList", saleOrderLine.getAnalyticDistributionLineList());
        }
    }

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        if (saleOrder == null) {
            saleOrder = (SaleOrder)((Object)request.getContext().getParentContext().asType(SaleOrder.class));
            saleOrderLine.setSaleOrder(saleOrder);
        }
        if (saleOrderLine.getAnalyticDistributionTemplate() == null) {
            throw new AxelorException(I18n.get((String)"No template selected"), 4, new Object[0]);
        }
        saleOrderLine = this.saleOrderLineServiceSupplyChainImpl.createAnalyticDistributionWithTemplate(saleOrderLine);
        response.setValue("analyticDistributionLineList", saleOrderLine.getAnalyticDistributionLineList());
    }
}

