/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StockMoveInvoiceController {
    @Inject
    private StockMoveInvoiceService stockMoveInvoiceService;

    public void generateInvoice(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        Invoice invoice = null;
        try {
            stockMove = (StockMove)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId());
            invoice = stockMove.getSaleOrder() != null ? this.stockMoveInvoiceService.createInvoiceFromSaleOrder(stockMove, stockMove.getSaleOrder()) : (stockMove.getPurchaseOrder() != null ? this.stockMoveInvoiceService.createInvoiceFromPurchaseOrder(stockMove, stockMove.getPurchaseOrder()) : this.stockMoveInvoiceService.createInvoiceFromStockMove(stockMove));
            if (invoice != null) {
                response.setReload(true);
                response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
    }

    public void generateInvoiceConcatStockMove(ActionRequest request, ActionResponse response) {
        Object stockMoveListStr;
        List stockMoveMap;
        ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
        ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
        boolean isCustomerStockMove = true;
        if (request.getContext().get((Object)"customerStockMoveToInvoice") != null) {
            if (request.getContext().get((Object)"customerStockMoveToInvoice") instanceof List) {
                stockMoveMap = (List)request.getContext().get((Object)"customerStockMoveToInvoice");
                for (Map map : stockMoveMap) {
                    stockMoveIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                stockMoveListStr = (String)request.getContext().get((Object)"customerStockMoveToInvoice");
                for (String stockMoveId : ((String)stockMoveListStr).split(",")) {
                    stockMoveIdList.add(new Long(stockMoveId));
                }
            }
        } else {
            if (request.getContext().get((Object)"supplierStockMoveToInvoice") instanceof List) {
                stockMoveMap = (List)request.getContext().get((Object)"supplierStockMoveToInvoice");
                for (Map map : stockMoveMap) {
                    stockMoveIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                stockMoveListStr = (String)request.getContext().get((Object)"supplierStockMoveToInvoice");
                for (String stockMoveId : ((String)stockMoveListStr).split(",")) {
                    stockMoveIdList.add(new Long(stockMoveId));
                }
            }
            isCustomerStockMove = false;
        }
        for (Long stockMoveId : stockMoveIdList) {
            stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)stockMoveId)));
        }
        PaymentCondition paymentCondition = null;
        PaymentMode paymentMode = null;
        Partner contactPartner = null;
        if (request.getContext().get((Object)"paymentCondition") != null) {
            paymentCondition = (PaymentCondition)JPA.em().find(PaymentCondition.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"paymentCondition")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"paymentMode") != null) {
            paymentMode = (PaymentMode)((Object)JPA.em().find(PaymentMode.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"paymentMode")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            contactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        try {
            Map<String, Object> mapResult = null;
            mapResult = isCustomerStockMove ? this.stockMoveInvoiceService.createInvoiceFromMultiOutgoingStockMove(stockMoveList, paymentCondition, paymentMode, contactPartner) : this.stockMoveInvoiceService.createInvoiceFromMultiIncomingStockMove(stockMoveList, contactPartner);
            if (mapResult.get("invoiceId") != null) {
                response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(mapResult.get("invoiceId"))).map());
                response.setCanClose(true);
                if (mapResult.get("information") != null) {
                    response.setFlash((String)mapResult.get("information"));
                }
            } else if (mapResult.get("information") != null) {
                response.setFlash(I18n.get((String)"No invoice was generated") + ": <br/>" + (String)mapResult.get("information"));
            } else {
                ActionView.ActionViewBuilder confirmView = ActionView.define((String)"StockMove").model(StockMove.class.getName()).add("form", "stock-move-supplychain-concat-invoice-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
                if (mapResult.get("paymentConditionToCheck") != null) {
                    confirmView.context("contextPaymentConditionToCheck", (Object)"true");
                }
                if (mapResult.get("paymentModeToCheck") != null) {
                    confirmView.context("contextPaymentModeToCheck", (Object)"true");
                }
                if (mapResult.get("contactPartnerToCheck") != null) {
                    confirmView.context("contextContactPartnerToCheck", (Object)"true");
                    confirmView.context("contextPartnerId", (Object)mapResult.get("partnerId").toString());
                }
                if (isCustomerStockMove) {
                    confirmView.context("customerStockMoveToInvoice", (Object)Joiner.on((String)",").join(stockMoveIdList));
                } else {
                    confirmView.context("supplierStockMoveToInvoice", (Object)Joiner.on((String)",").join(stockMoveIdList));
                }
                response.setView(confirmView.map());
            }
        }
        catch (AxelorException ae) {
            response.setFlash(ae.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateMultiInvoice(ActionRequest request, ActionResponse response) {
        List stockMoveMap = null;
        boolean isCustomerStockMove = true;
        if (request.getContext().get((Object)"customerStockMoveToInvoice") != null) {
            stockMoveMap = (List)request.getContext().get((Object)"customerStockMoveToInvoice");
        } else {
            stockMoveMap = (List)request.getContext().get((Object)"supplierStockMoveToInvoice");
            isCustomerStockMove = false;
        }
        StringBuilder stockMovesInError = new StringBuilder();
        ArrayList<Long> invoiceIdList = new ArrayList<Long>();
        Invoice invoice = null;
        StockMove stockMove = null;
        if (isCustomerStockMove) {
            for (Map map : stockMoveMap) {
                try {
                    stockMove = (StockMove)((Object)JPA.em().find(StockMove.class, (Object)new Long(((Integer)map.get("id")).intValue())));
                    invoice = this.stockMoveInvoiceService.createInvoiceFromSaleOrder(stockMove, stockMove.getSaleOrder());
                    invoiceIdList.add(invoice.getId());
                }
                catch (AxelorException ae) {
                    if (stockMovesInError.length() > 0) {
                        stockMovesInError.append("<br/>");
                    }
                    stockMovesInError.append(String.format(I18n.get((String)"The invoice for the stock move %s can't be generated because of this following error : %s"), stockMove.getName(), ae.getLocalizedMessage()));
                }
                catch (Exception e) {
                    TraceBackService.trace((Exception)e);
                }
                finally {
                    if (invoiceIdList.size() % 10 != 0) continue;
                    JPA.clear();
                }
            }
        } else {
            for (Map map : stockMoveMap) {
                try {
                    stockMove = (StockMove)((Object)JPA.em().find(StockMove.class, (Object)new Long(((Integer)map.get("id")).intValue())));
                    invoice = this.stockMoveInvoiceService.createInvoiceFromPurchaseOrder(stockMove, stockMove.getPurchaseOrder());
                    invoiceIdList.add(invoice.getId());
                }
                catch (AxelorException ae) {
                    if (stockMovesInError.length() > 0) {
                        stockMovesInError.append("<br/>");
                    }
                    stockMovesInError.append(String.format(I18n.get((String)"The invoice for the stock move %s can't be generated because of this following error : %s"), stockMove.getName(), ae.getLocalizedMessage()));
                }
                catch (Exception e) {
                    TraceBackService.trace((Exception)e);
                }
                finally {
                    if (invoiceIdList.size() % 10 != 0) continue;
                    JPA.clear();
                }
            }
        }
        if (!invoiceIdList.isEmpty()) {
            ActionView.ActionViewBuilder viewBuilder = null;
            viewBuilder = isCustomerStockMove ? ActionView.define((String)"Cust. Invoices") : ActionView.define((String)"Suppl. Invoices");
            viewBuilder.model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain("self.id IN (" + Joiner.on((String)",").join(invoiceIdList) + ")");
            response.setView(viewBuilder.map());
        }
        if (stockMovesInError.length() > 0) {
            response.setFlash(stockMovesInError.toString());
        }
    }
}

