/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.SubscriptionService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.TypedQuery;

public class SubscriptionController {
    @Inject
    protected SubscriptionService subscriptionService;
    @Inject
    protected SaleOrderLineRepository saleOrderLineRepo;
    @Inject
    protected GeneralService generalService;

    public void generateSubscriptions(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        if (saleOrderLine.getId() != null && saleOrderLine.getId() > 0L) {
            saleOrderLine = (SaleOrderLine)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId());
        }
        saleOrderLine = this.subscriptionService.generateSubscriptions(saleOrderLine);
        response.setValue("subscriptionList", saleOrderLine.getSubscriptionList());
    }

    @Transactional
    public void generateAllSubscriptions(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        saleOrder = (SaleOrder)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId());
        this.subscriptionService.generateAllSubscriptions(saleOrder);
        response.setReload(true);
    }

    public void generateInvoice(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        if ((saleOrderLine = (SaleOrderLine)this.saleOrderLineRepo.find(saleOrderLine.getId())) != null) {
            Invoice invoice = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).generateSubcriptionInvoiceForSaleOrderLine(saleOrderLine);
            if (invoice == null) {
                throw new AxelorException(I18n.get((String)"No Subscription to Invoice"), 4, new Object[0]);
            }
            response.setCanClose(true);
            response.setView(ActionView.define((String)I18n.get((String)"Invoice Generated")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateInvoiceForAllSubscriptions(ActionRequest request, ActionResponse response) throws AxelorException {
        TypedQuery q = JPA.em().createQuery("SELECT DISTINCT saleOrderLine.saleOrder.id FROM Subscription WHERE invoicingDate <= ?1 AND invoiced = false ", Long.class);
        q.setParameter(1, (Object)this.generalService.getTodayDate());
        List saleOrderIdList = q.getResultList();
        if (saleOrderIdList != null) {
            SaleOrder saleOrder = null;
            ArrayList<Long> invoiceIdList = new ArrayList<Long>();
            for (Long saleOrderId : saleOrderIdList) {
                saleOrder = (SaleOrder)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrderId);
                try {
                    Invoice invoice = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).generateSubcriptionInvoiceForSaleOrder(saleOrder);
                    invoiceIdList.add(invoice.getId());
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)e);
                }
                finally {
                    if (invoiceIdList.size() % 10 != 0) continue;
                    JPA.clear();
                }
            }
            if (!invoiceIdList.isEmpty()) {
                response.setReload(true);
                response.setView(ActionView.define((String)I18n.get((String)"Invoices Generated")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain("self.id IN (" + Joiner.on((String)",").join(invoiceIdList) + ")").map());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateInvoiceForSelectedSubscriptions(ActionRequest request, ActionResponse response) throws AxelorException {
        List listSelectedSubscriptionsTemp = (List)request.getContext().get((Object)"_ids");
        ArrayList<Long> listSelectedSubscriptions = new ArrayList<Long>();
        for (Integer intId : listSelectedSubscriptionsTemp) {
            listSelectedSubscriptions.add(intId.longValue());
        }
        TypedQuery q = JPA.em().createQuery("SELECT DISTINCT new List(saleOrderLine.saleOrder.id as saleOrderId, id as subscriptionId) FROM Subscription WHERE id IN (:subscriptionIds)", List.class);
        q.setParameter("subscriptionIds", listSelectedSubscriptions);
        List soIdsubscriptionIdList = q.getResultList();
        if (listSelectedSubscriptions != null) {
            HashMap subscriptionsBySaleOrderMap = new HashMap();
            for (List soIdsubscriptionId : soIdsubscriptionIdList) {
                if (subscriptionsBySaleOrderMap.containsKey(soIdsubscriptionId.get(0))) {
                    ((List)subscriptionsBySaleOrderMap.get(soIdsubscriptionId.get(0))).add(soIdsubscriptionId.get(1));
                    continue;
                }
                ArrayList subscriptionIdList = new ArrayList();
                subscriptionIdList.add(soIdsubscriptionId.get(1));
                subscriptionsBySaleOrderMap.put(soIdsubscriptionId.get(0), subscriptionIdList);
            }
            ArrayList<Long> invoiceIdList = new ArrayList<Long>();
            for (Map.Entry entry : subscriptionsBySaleOrderMap.entrySet()) {
                try {
                    Invoice invoice = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).generateSubcriptionInvoiceForSaleOrderAndListSubscrip((Long)entry.getKey(), (List)entry.getValue());
                    invoiceIdList.add(invoice.getId());
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)e);
                }
                finally {
                    if (invoiceIdList.size() % 10 != 0) continue;
                    JPA.clear();
                }
            }
            if (!invoiceIdList.isEmpty()) {
                response.setView(ActionView.define((String)I18n.get((String)"Invoices Generated")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain("self.id IN (" + Joiner.on((String)",").join(invoiceIdList) + ")").map());
            }
        }
    }
}

