/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.SaleOrderLineService;
import com.axelor.apps.sale.service.SaleOrderService;
import com.axelor.apps.stock.db.Inventory;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.InventoryRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.InventoryService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Map;
import javax.persistence.Query;
import org.joda.time.LocalDate;

public class ValidateSupplyChain {
    @Inject
    InventoryService inventoryService;
    @Inject
    PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    @Inject
    InvoiceService invoiceService;
    @Inject
    SaleOrderStockService saleOrderStockService;
    @Inject
    SaleOrderLineService saleOrderLineService;
    @Inject
    private StockMoveRepository stockMoveRepo;
    @Inject
    private InventoryRepository inventoryRepo;
    @Inject
    private PurchaseOrderRepository purchaseOrderRepo;
    @Inject
    private SaleOrderRepository saleOrderRepo;

    public Object validateSupplyChain(Object bean, Map values) {
        String objectQuery = "(SELECT 'inv' as type,id,datet as date from stock_inventory) UNION ALL(SELECT 'so' as type,id,confirmation_date as date from sale_sale_order) UNION ALL(SELECT 'po' as type,id,order_date as date from purchase_purchase_order) order by date";
        Query query = JPA.em().createNativeQuery(objectQuery);
        for (Object objects : query.getResultList()) {
            Object[] object = (Object[])objects;
            if (object[0].toString().equals("inv")) {
                this.validateInventory(Long.parseLong(object[1].toString()));
                continue;
            }
            if (object[0].toString().equals("po")) {
                this.validatePurchaseOrder(Long.parseLong(object[1].toString()));
                continue;
            }
            this.validateSaleOrder(Long.parseLong(object[1].toString()));
        }
        return bean;
    }

    @Transactional
    void validateInventory(Long inventoryId) {
        try {
            Inventory inventory = (Inventory)this.inventoryRepo.find(inventoryId);
            StockMove stockMove = this.inventoryService.generateStockMove(inventory);
            stockMove.setRealDate(inventory.getDateT().toLocalDate());
            this.stockMoveRepo.save((Model)stockMove);
            inventory.setStatusSelect(Integer.valueOf(3));
            this.inventoryRepo.save((Model)inventory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    void validatePurchaseOrder(Long poId) {
        StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)this.purchaseOrderRepo.find(poId);
            this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
            if (purchaseOrder.getStatusSelect() == 4 || purchaseOrder.getStatusSelect() == 5 && purchaseOrder.getLocation() == null) {
                this.purchaseOrderServiceSupplychainImpl.createStocksMove(purchaseOrder);
                StockMove stockMove = (StockMove)this.stockMoveRepo.all().filter("purchaseOrder.id = ?1", new Object[]{purchaseOrder.getId()}).fetchOne();
                if (stockMove != null) {
                    stockMoveService.copyQtyToRealQty(stockMove);
                    stockMoveService.realize(stockMove);
                    stockMove.setRealDate(purchaseOrder.getDeliveryDate());
                }
                purchaseOrder.setValidationDate(purchaseOrder.getOrderDate());
                purchaseOrder.setValidatedByUser(AuthUtils.getUser());
                purchaseOrder.setSupplierPartner(this.purchaseOrderServiceSupplychainImpl.validateSupplier(purchaseOrder));
                Invoice invoice = ((PurchaseOrderInvoiceService)Beans.get(PurchaseOrderInvoiceService.class)).generateInvoice(purchaseOrder);
                if (purchaseOrder.getValidationDate() != null) {
                    invoice.setInvoiceDate(purchaseOrder.getValidationDate());
                } else {
                    invoice.setInvoiceDate(new LocalDate());
                }
                this.invoiceService.compute(invoice);
                this.invoiceService.validate(invoice);
                this.invoiceService.ventilate(invoice);
            }
            this.purchaseOrderRepo.save((Model)purchaseOrder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    void validateSaleOrder(Long soId) {
        SaleOrderService saleOrderService = (SaleOrderService)Beans.get(SaleOrderService.class);
        StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
        try {
            SaleOrder saleOrder = (SaleOrder)this.saleOrderRepo.find(soId);
            for (SaleOrderLine line : saleOrder.getSaleOrderLineList()) {
                line.setTaxLine(this.saleOrderLineService.getTaxLine(saleOrder, line));
            }
            saleOrderService.computeSaleOrder(saleOrder);
            if (saleOrder.getStatusSelect() == 3) {
                this.saleOrderStockService.createStocksMovesFromSaleOrder(saleOrder);
                ((SaleOrderPurchaseService)Beans.get(SaleOrderPurchaseService.class)).createPurchaseOrders(saleOrder);
                saleOrder.setClientPartner(saleOrderService.validateCustomer(saleOrder));
                Invoice invoice = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).generateInvoice(saleOrder);
                if (saleOrder.getConfirmationDate() != null) {
                    invoice.setInvoiceDate(saleOrder.getConfirmationDate());
                } else {
                    invoice.setInvoiceDate(new LocalDate());
                }
                this.invoiceService.compute(invoice);
                this.invoiceService.validate(invoice);
                this.invoiceService.ventilate(invoice);
                StockMove stockMove = (StockMove)this.stockMoveRepo.all().filter("saleOrder = ?1", new Object[]{saleOrder}).fetchOne();
                if (stockMove != null && stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
                    stockMoveService.copyQtyToRealQty(stockMove);
                    stockMoveService.validate(stockMove);
                    stockMove.setRealDate(saleOrder.getConfirmationDate());
                }
            }
            this.saleOrderRepo.save((Model)saleOrder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

